"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TakeAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _can_add_to_block_list = require("../../../../block_list/utils/can_add_to_block_list");
var _add_to_block_list = require("../../../../block_list/components/add_to_block_list");
var _add_to_new_case = require("../../../../cases/components/add_to_new_case/add_to_new_case");
var _add_to_existing_case = require("../../../../cases/components/add_to_existing_case/add_to_existing_case");
var _timeline = require("../../../../timeline");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Component rendered at the bottom of the indicators flyout
 */
const TakeAction = ({
  indicator
}) => {
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const smallContextMenuPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'smallContextMenuPopover'
  });
  const closePopover = () => {
    setPopover(false);
  };
  const indicatorValue = (0, _can_add_to_block_list.canAddToBlockList)(indicator);
  const items = [/*#__PURE__*/_react.default.createElement(_timeline.InvestigateInTimelineContextMenu, {
    data: indicator,
    onClick: closePopover,
    "data-test-subj": _test_ids.INVESTIGATE_IN_TIMELINE_TEST_ID
  }), /*#__PURE__*/_react.default.createElement(_add_to_existing_case.AddToExistingCase, {
    indicator: indicator,
    onClick: closePopover,
    "data-test-subj": _test_ids.ADD_TO_EXISTING_CASE_TEST_ID
  }), /*#__PURE__*/_react.default.createElement(_add_to_new_case.AddToNewCase, {
    indicator: indicator,
    onClick: closePopover,
    "data-test-subj": _test_ids.ADD_TO_NEW_CASE_TEST_ID
  }), /*#__PURE__*/_react.default.createElement(_add_to_block_list.AddToBlockListContextMenu, {
    data: indicatorValue,
    onClick: closePopover,
    "data-test-subj": _test_ids.ADD_TO_BLOCK_LIST_TEST_ID
  })];
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "arrowDown",
    iconSide: "right",
    onClick: () => setPopover(!isPopoverOpen)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.threatIntelligence.indicators.flyout.take-action.button",
    defaultMessage: "Take action"
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: smallContextMenuPopoverId,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    "data-test-subj": _test_ids.TAKE_ACTION_BUTTON_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: items
  }));
};
exports.TakeAction = TakeAction;