"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorsFlyoutTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _empty_prompt = require("../empty_prompt");
var _fields_table = require("../fields_table");
var _test_ids = require("./test_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const search = {
  box: {
    incremental: true,
    schema: true
  }
};
/**
 * Displays all the properties and values of an {@link Indicator} in table view,
 * using the {@link EuiInMemoryTable} from the @elastic/eui library.
 */
const IndicatorsFlyoutTable = ({
  indicator
}) => {
  const items = Object.keys(indicator.fields);
  return items.length === 0 ? /*#__PURE__*/_react.default.createElement(_empty_prompt.IndicatorEmptyPrompt, null) : /*#__PURE__*/_react.default.createElement(_fields_table.IndicatorFieldsTable, {
    "data-test-subj": _test_ids.FLYOUT_TABLE_TEST_ID,
    search: search,
    fields: items,
    indicator: indicator
  });
};
exports.IndicatorsFlyoutTable = IndicatorsFlyoutTable;