"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightedValuesTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _indicator = require("../../../../../../../common/types/indicator");
var _utils = require("../../../../utils");
var _fields_table = require("../../fields_table");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Pick indicator fields starting with the indicator type
 */
const byIndicatorType = indicatorType => field => field.startsWith(`threat.indicator.${indicatorType}`) || ['threat.indicator.reference', 'threat.indicator.description', 'threat.software.alias', 'threat.indicator.confidence', 'threat.tactic.name', 'threat.tactic.reference'].includes(field);
/**
 * Displays highlighted indicator values based on indicator type
 */
const HighlightedValuesTable = ({
  indicator,
  'data-test-subj': dataTestSubj
}) => {
  const indicatorType = (0, _utils.unwrapValue)(indicator, _indicator.RawIndicatorFieldId.Type);
  const highlightedFields = (0, _react.useMemo)(() => Object.keys(indicator.fields).filter(byIndicatorType(indicatorType || '')), [indicator.fields, indicatorType]);
  return /*#__PURE__*/_react.default.createElement(_fields_table.IndicatorFieldsTable, {
    search: false,
    indicator: indicator,
    fields: highlightedFields,
    "data-test-subj": dataTestSubj
  });
};
exports.HighlightedValuesTable = HighlightedValuesTable;