"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorsFlyoutJson = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _empty_prompt = require("../empty_prompt");
var _test_ids = require("./test_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Displays all the properties and values of an {@link Indicator} in json view,
 * using the {@link EuiCodeBlock} from the @elastic/eui library.
 */
const IndicatorsFlyoutJson = ({
  indicator
}) => {
  return Object.keys(indicator).length === 0 ? /*#__PURE__*/_react.default.createElement(_empty_prompt.IndicatorEmptyPrompt, null) : /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    lineNumbers: true,
    "data-test-subj": _test_ids.CODE_BLOCK_TEST_ID
  }, JSON.stringify(indicator, null, 2));
};
exports.IndicatorsFlyoutJson = IndicatorsFlyoutJson;