"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorBarchartLegendAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _copy_to_clipboard = require("../../copy_to_clipboard");
var _query_bar = require("../../../../query_bar");
var _timeline = require("../../../../timeline");
var _test_ids = require("./test_ids");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndicatorBarchartLegendAction = ({
  data,
  field
}) => {
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const group = field.value === 'date' ? (0, _moment.default)(data).toISOString() : data;
  const popoverItems = [/*#__PURE__*/_react.default.createElement(_query_bar.FilterInContextMenu, {
    key: _test_ids.FILTER_IN_BUTTON_TEST_ID,
    data: group,
    field: field.label,
    "data-test-subj": _test_ids.FILTER_IN_BUTTON_TEST_ID
  }), /*#__PURE__*/_react.default.createElement(_query_bar.FilterOutContextMenu, {
    key: _test_ids.FILTER_OUT_BUTTON_TEST_ID,
    data: group,
    field: field.label,
    "data-test-subj": _test_ids.FILTER_OUT_BUTTON_TEST_ID
  }), /*#__PURE__*/_react.default.createElement(_timeline.AddToTimelineContextMenu, {
    key: _test_ids.TIMELINE_BUTTON_TEST_ID,
    data: group,
    field: field.label,
    "data-test-subj": _test_ids.TIMELINE_BUTTON_TEST_ID
  }), /*#__PURE__*/_react.default.createElement(_copy_to_clipboard.CopyToClipboardContextMenu, {
    key: _test_ids.COPY_TO_CLIPBOARD_BUTTON_TEST_ID,
    value: group,
    "data-test-subj": _test_ids.COPY_TO_CLIPBOARD_BUTTON_TEST_ID
  })];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": _test_ids.POPOVER_BUTTON_TEST_ID,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _translations.BUTTON_LABEL
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _translations.BUTTON_LABEL,
      iconType: "boxesHorizontal",
      iconSize: "s",
      size: "xs",
      onClick: () => setPopover(prevIsPopoverOpen => !prevIsPopoverOpen),
      style: {
        height: '100%'
      }
    })),
    isOpen: isPopoverOpen,
    closePopover: () => setPopover(false),
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: popoverItems
  }));
};
exports.IndicatorBarchartLegendAction = IndicatorBarchartLegendAction;