"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSetUrlParams = void 0;
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Retrieve the useSetUrlParams hook from SecurityContext.
 * The hook is passed down from the Security Solution plugin.
 */
const useSetUrlParams = () => {
  const {
    blockList
  } = (0, _hooks.useSecurityContext)();
  return {
    setUrlParams: blockList.useSetUrlParams()
  };
};
exports.useSetUrlParams = useSetUrlParams;