"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecuritySolutionPluginTemplateWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_kibana = require("../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Uses securityLayout service to retrieve shared plugin wrapper component and renders plugin routes / children inside of it.
 *
 * The `template` prop can be used to alter the page layout for a given plugin route / all routes within a plugin - depending on the nesting.
 */
const SecuritySolutionPluginTemplateWrapper = ({
  children,
  ...rest
}) => {
  const {
    services: {
      securityLayout: {
        getPluginWrapper
      }
    }
  } = (0, _use_kibana.useKibana)();
  const Wrapper = getPluginWrapper();
  return /*#__PURE__*/_react.default.createElement(Wrapper, rest, children);
};
exports.SecuritySolutionPluginTemplateWrapper = SecuritySolutionPluginTemplateWrapper;