"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultPageLayout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _security_solution_page_wrapper = require("../../containers/security_solution_page_wrapper");
var _test_ids = require("./test_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DefaultPageLayout = ({
  children,
  pageTitle,
  border = true,
  subHeader
}) => {
  return /*#__PURE__*/_react.default.createElement(_security_solution_page_wrapper.SecuritySolutionPageWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    alignItems: "center",
    bottomBorder: border
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, null, pageTitle && /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": _test_ids.TITLE_TEST_ID
  }, pageTitle)), subHeader ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), subHeader) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), children);
};
exports.DefaultPageLayout = DefaultPageLayout;