"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDateDifferenceInDays = exports.dateFormatter = exports.barChartTimeAxisLabelFormatter = exports.FULL_DATE = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _charts = require("@elastic/charts");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

_moment.default.suppressDeprecationWarnings = true;
const FULL_DATE = 'MMMM Do YYYY @ HH:mm:ss';

/**
 * Converts a string or moment date to the 'MMMM Do YYYY @ HH:mm:ss' format.
 * @param date Date to be formatted
 * @param timeZone Timezone used to format the date
 * @param format Optional format used by moment to format the date
 * @returns The formatted string or {@link EMPTY_VALUE} if the input date wasn't valid
 */
exports.FULL_DATE = FULL_DATE;
const dateFormatter = (date, timeZone, format) => {
  const momentDate = typeof date === 'string' ? _moment.default.tz(date, timeZone) : date.tz(timeZone);
  return momentDate.isValid() ? momentDate.format(format) : _constants.EMPTY_VALUE;
};

/**
 * Calculates the difference in days between two moment dates
 * @param minDate Min (older) date
 * @param maxDate Max (newer) date
 * @returns The number of days between the two input dates (returns 2 if the difference is less than 1 to play nice with the {@link niceTimeFormatByDay} function
 */
exports.dateFormatter = dateFormatter;
const getDateDifferenceInDays = (minDate, maxDate) => {
  const differenceInDays = maxDate.diff(minDate, 'days');
  if (differenceInDays <= 1 && !minDate.isSame(maxDate)) {
    return 2; // to return proper pattern from niceTimeFormatByDay
  }

  return differenceInDays;
};

/**
 * Nicely formats the label for a BartChart's time axis (uses {@link niceTimeFormatByDay} and {@link timeFormatter}from the '@elastic/charts' library)
 * @param dateRange Min and max values for the time axis ({@link TimeRangeBounds})
 * @returns A function ({@link timeFormatter} from the '@elastic/charts' library) that returns a formatted label as a string
 */
exports.getDateDifferenceInDays = getDateDifferenceInDays;
const barChartTimeAxisLabelFormatter = dateRange => {
  const diff = getDateDifferenceInDays(dateRange.min, dateRange.max);
  const format = (0, _charts.niceTimeFormatByDay)(diff);
  return (0, _charts.timeFormatter)(format);
};
exports.barChartTimeAxisLabelFormatter = barChartTimeAxisLabelFormatter;