"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecuritySolutionNavTab = exports.getSecuritySolutionLink = exports.getSecuritySolutionDeepLink = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Gets the threat intelligence properties of a TI page for deep linking in the security solution.
 * @param threatIntelligencePage the name of the threat intelligence page.
 * @returns a {@link TIDeepLink}
 */
const getSecuritySolutionDeepLink = threatIntelligencePage => ({
  id: _constants.threatIntelligencePages[threatIntelligencePage].id,
  title: _constants.threatIntelligencePages[threatIntelligencePage].newNavigationName,
  path: _constants.threatIntelligencePages[threatIntelligencePage].path,
  keywords: _constants.threatIntelligencePages[threatIntelligencePage].keywords
});

/**
 * Gets the threat intelligence properties of a TI page for navigation in the security solution.
 * @param threatIntelligencePage the name of the threat intelligence page.
 * @returns a {@link TILinkItem}
 */
exports.getSecuritySolutionDeepLink = getSecuritySolutionDeepLink;
const getSecuritySolutionLink = threatIntelligencePage => ({
  id: _constants.threatIntelligencePages[threatIntelligencePage].id,
  title: _constants.threatIntelligencePages[threatIntelligencePage].newNavigationName,
  path: _constants.threatIntelligencePages[threatIntelligencePage].path,
  description: _constants.threatIntelligencePages[threatIntelligencePage].description,
  globalSearchKeywords: _constants.threatIntelligencePages[threatIntelligencePage].globalSearchKeywords
});

/**
 * Gets the threat intelligence properties of a TI page for navigation in the old security solution navigation.
 * @param threatIntelligencePage the name of the threat intelligence page.
 * @param basePath the base path for links.
 * @returns a {@link TINavTab}
 */
exports.getSecuritySolutionLink = getSecuritySolutionLink;
const getSecuritySolutionNavTab = (threatIntelligencePage, basePath) => ({
  id: _constants.threatIntelligencePages[threatIntelligencePage].id,
  name: _constants.threatIntelligencePages[threatIntelligencePage].oldNavigationName,
  href: `${basePath}${_constants.threatIntelligencePages[threatIntelligencePage].path}`,
  disabled: _constants.threatIntelligencePages[threatIntelligencePage].disabled
});
exports.getSecuritySolutionNavTab = getSecuritySolutionNavTab;