"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerTelemetryLastReported = registerTelemetryLastReported;
var _rxjs = require("rxjs");
var _saved_objects = require("../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function registerTelemetryLastReported(router, savedObjectsInternalClient$) {
  // GET to retrieve
  router.get({
    path: '/api/telemetry/v2/last_reported',
    validate: false
  }, async (context, req, res) => {
    const savedObjectsInternalClient = await (0, _rxjs.firstValueFrom)(savedObjectsInternalClient$);
    const telemetrySavedObject = await (0, _saved_objects.getTelemetrySavedObject)(savedObjectsInternalClient);
    const body = {
      lastReported: telemetrySavedObject && (telemetrySavedObject === null || telemetrySavedObject === void 0 ? void 0 : telemetrySavedObject.lastReported)
    };
    return res.ok({
      body
    });
  });

  // PUT to update
  router.put({
    path: '/api/telemetry/v2/last_reported',
    validate: false
  }, async (context, req, res) => {
    const savedObjectsInternalClient = await (0, _rxjs.firstValueFrom)(savedObjectsInternalClient$);
    await (0, _saved_objects.updateTelemetrySavedObject)(savedObjectsInternalClient, {
      lastReported: Date.now()
    });
    return res.ok();
  });
}