"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerTelemetryConfigRoutes = registerTelemetryConfigRoutes;
var _rxjs = require("rxjs");
var _routes = require("../../common/routes");
var _saved_objects = require("../saved_objects");
var _telemetry_config = require("../telemetry_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function registerTelemetryConfigRoutes({
  router,
  config$,
  currentKibanaVersion,
  savedObjectsInternalClient$
}) {
  // GET to retrieve
  router.get({
    path: _routes.FetchTelemetryConfigRoute,
    validate: false
  }, async (context, req, res) => {
    const config = await (0, _rxjs.firstValueFrom)(config$);
    const savedObjectsInternalClient = await (0, _rxjs.firstValueFrom)(savedObjectsInternalClient$);
    const telemetrySavedObject = await (0, _saved_objects.getTelemetrySavedObject)(savedObjectsInternalClient);
    const allowChangingOptInStatus = (0, _telemetry_config.getTelemetryAllowChangingOptInStatus)({
      configTelemetryAllowChangingOptInStatus: config.allowChangingOptInStatus,
      telemetrySavedObject
    });
    const optIn = (0, _telemetry_config.getTelemetryOptIn)({
      configTelemetryOptIn: config.optIn,
      allowChangingOptInStatus,
      telemetrySavedObject,
      currentKibanaVersion
    });
    const sendUsageFrom = (0, _telemetry_config.getTelemetrySendUsageFrom)({
      configTelemetrySendUsageFrom: config.sendUsageFrom,
      telemetrySavedObject
    });
    const telemetryNotifyUserAboutOptInDefault = (0, _telemetry_config.getNotifyUserAboutOptInDefault)({
      telemetrySavedObject,
      allowChangingOptInStatus,
      configTelemetryOptIn: config.optIn,
      telemetryOptedIn: optIn
    });
    const body = {
      allowChangingOptInStatus,
      optIn,
      sendUsageFrom,
      telemetryNotifyUserAboutOptInDefault
    };
    return res.ok({
      body
    });
  });
}