"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptInMessage = void 0;
var React = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const OptInMessage = ({
  addBasePath,
  telemetryService,
  telemetryConstants,
  onClick
}) => {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
    id: "telemetry.dataManagementDisclaimerPrivacy",
    defaultMessage: "Usage collection (also known as Telemetry) is {optInStatus}. This allows us to learn what our users are most interested in, so we can improve our products and services. Refer to our {privacyStatementLink}.",
    values: {
      optInStatus: /*#__PURE__*/React.createElement("em", null, telemetryService.isOptedIn ? /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
        id: "telemetry.enabledStatus",
        defaultMessage: "enabled"
      }) : /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
        id: "telemetry.disabledStatus",
        defaultMessage: "disabled"
      })),
      privacyStatementLink:
      /*#__PURE__*/
      /* eslint-disable-next-line @elastic/eui/href-or-on-click */
      React.createElement(_eui.EuiLink, {
        onClick: onClick,
        href: telemetryConstants.getPrivacyStatementUrl(),
        target: "_blank",
        rel: "noopener"
      }, /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
        id: "telemetry.dataManagementDisclaimerPrivacyLink",
        defaultMessage: "Privacy Statement"
      }))
    }
  }), ' ', renderTelemetryEnabledOrDisabledText(telemetryService, addBasePath, onClick));
};
exports.OptInMessage = OptInMessage;
function renderTelemetryEnabledOrDisabledText(telemetryService, addBasePath, onClick) {
  if (!telemetryService.userCanChangeSettings || !telemetryService.getCanChangeOptInStatus()) {
    return null;
  }
  const isOptedIn = telemetryService.getIsOptedIn();
  const actionMessage = isOptedIn ? /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
    id: "telemetry.dataManagementDisableCollectionLink",
    defaultMessage: "Disable usage collection."
  }) : /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
    id: "telemetry.dataManagementEnableCollectionLink",
    defaultMessage: "Enable usage collection."
  });
  return (
    /*#__PURE__*/
    /* eslint-disable-next-line @elastic/eui/href-or-on-click */
    React.createElement(_eui.EuiLink, {
      href: addBasePath('management/kibana/settings'),
      onClick: onClick
    }, actionMessage)
  );
}