"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizeThrottling = exports.getNormalizeBrowserFields = void 0;
var _runtime_types = require("../../../../common/runtime_types");
var _monitor_defaults = require("../../../../common/constants/monitor_defaults");
var _common_fields = require("./common_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getNormalizeBrowserFields = ({
  locations = [],
  privateLocations = [],
  monitor,
  projectId,
  namespace,
  version
}) => {
  var _monitor$filter;
  const defaultFields = _monitor_defaults.DEFAULT_FIELDS[_runtime_types.DataStream.BROWSER];
  const {
    errors,
    normalizedFields: commonFields
  } = (0, _common_fields.getNormalizeCommonFields)({
    locations,
    privateLocations,
    monitor,
    projectId,
    namespace,
    version
  });
  const throttling = normalizeThrottling(monitor.throttling);
  const normalizedFields = {
    ...commonFields,
    [_runtime_types.ConfigKey.MONITOR_TYPE]: _runtime_types.DataStream.BROWSER,
    [_runtime_types.ConfigKey.FORM_MONITOR_TYPE]: _runtime_types.FormMonitorType.MULTISTEP,
    [_runtime_types.ConfigKey.SOURCE_PROJECT_CONTENT]: monitor.content || defaultFields[_runtime_types.ConfigKey.SOURCE_PROJECT_CONTENT],
    [_runtime_types.ConfigKey.THROTTLING_CONFIG]: throttling,
    [_runtime_types.ConfigKey.IGNORE_HTTPS_ERRORS]: monitor.ignoreHTTPSErrors || defaultFields[_runtime_types.ConfigKey.IGNORE_HTTPS_ERRORS],
    [_runtime_types.ConfigKey.SCREENSHOTS]: monitor.screenshot || defaultFields[_runtime_types.ConfigKey.SCREENSHOTS],
    [_runtime_types.ConfigKey.PLAYWRIGHT_OPTIONS]: Object.keys(monitor.playwrightOptions || {}).length ? JSON.stringify(monitor.playwrightOptions) : defaultFields[_runtime_types.ConfigKey.PLAYWRIGHT_OPTIONS],
    [_runtime_types.ConfigKey.JOURNEY_FILTERS_MATCH]: ((_monitor$filter = monitor.filter) === null || _monitor$filter === void 0 ? void 0 : _monitor$filter.match) || defaultFields[_runtime_types.ConfigKey.JOURNEY_FILTERS_MATCH],
    [_runtime_types.ConfigKey.TIMEOUT]: monitor.timeout ? (0, _common_fields.getValueInSeconds)(monitor.timeout) : defaultFields[_runtime_types.ConfigKey.TIMEOUT]
  };
  return {
    normalizedFields: {
      ...defaultFields,
      ...normalizedFields
    },
    unsupportedKeys: [],
    errors
  };
};
exports.getNormalizeBrowserFields = getNormalizeBrowserFields;
const normalizeThrottling = monitorThrottling => {
  const defaultFields = _monitor_defaults.DEFAULT_FIELDS[_runtime_types.DataStream.BROWSER];
  let throttling = defaultFields[_runtime_types.ConfigKey.THROTTLING_CONFIG];
  if (typeof monitorThrottling === 'boolean' && !monitorThrottling) {
    throttling = _monitor_defaults.PROFILES_MAP[_monitor_defaults.PROFILE_VALUES_ENUM.NO_THROTTLING];
  }
  if (typeof monitorThrottling === 'object') {
    const {
      download,
      upload,
      latency
    } = monitorThrottling;
    const matchedProfile = _monitor_defaults.PROFILE_VALUES.find(({
      value
    }) => {
      return Number(value === null || value === void 0 ? void 0 : value.download) === download && Number(value === null || value === void 0 ? void 0 : value.upload) === upload && Number(value === null || value === void 0 ? void 0 : value.latency) === latency;
    });
    if (matchedProfile) {
      return matchedProfile;
    } else {
      return {
        id: _monitor_defaults.PROFILE_VALUES_ENUM.CUSTOM,
        label: _monitor_defaults.CUSTOM_LABEL,
        value: {
          download: String(download),
          upload: String(upload),
          latency: String(latency)
        }
      };
    }
  }
  return throttling;
};
exports.normalizeThrottling = normalizeThrottling;