"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.httpFormatters = void 0;
var _formatters = require("../../../common/formatters/http/formatters");
var _common = require("./common");
var _tls = require("./tls");
var _monitor_management = require("../../../common/runtime_types/monitor_management");
var _formatting_utils = require("./formatting_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const httpFormatters = {
  ..._formatters.httpFormatters,
  [_monitor_management.ConfigKey.METADATA]: _formatting_utils.objectFormatter,
  [_monitor_management.ConfigKey.RESPONSE_BODY_CHECK_NEGATIVE]: _formatting_utils.arrayFormatter,
  [_monitor_management.ConfigKey.RESPONSE_BODY_CHECK_POSITIVE]: _formatting_utils.arrayFormatter,
  [_monitor_management.ConfigKey.RESPONSE_JSON_CHECK]: _formatting_utils.arrayFormatter,
  [_monitor_management.ConfigKey.RESPONSE_HEADERS_CHECK]: _formatting_utils.objectFormatter,
  [_monitor_management.ConfigKey.RESPONSE_STATUS_CHECK]: _formatting_utils.arrayFormatter,
  [_monitor_management.ConfigKey.REQUEST_HEADERS_CHECK]: _formatting_utils.objectFormatter,
  [_monitor_management.ConfigKey.REQUEST_BODY_CHECK]: fields => {
    var _fields$ConfigKey$REQ;
    return ((_fields$ConfigKey$REQ = fields[_monitor_management.ConfigKey.REQUEST_BODY_CHECK]) === null || _fields$ConfigKey$REQ === void 0 ? void 0 : _fields$ConfigKey$REQ.value) || null;
  },
  [_monitor_management.ConfigKey.PROXY_HEADERS]: _formatting_utils.objectFormatter,
  ..._tls.tlsFormatters,
  ..._common.commonFormatters
};
exports.httpFormatters = httpFormatters;