"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.commonFormatters = void 0;
var _formatting_utils = require("./formatting_utils");
var _formatters = require("../../../common/formatters/common/formatters");
var _runtime_types = require("../../../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const commonFormatters = {
  ..._formatters.commonFormatters,
  [_runtime_types.ConfigKey.PARAMS]: _formatting_utils.stringToObjectFormatter,
  [_runtime_types.ConfigKey.SCHEDULE]: fields => {
    var _fields$ConfigKey$SCH, _fields$ConfigKey$SCH2;
    return `@every ${(_fields$ConfigKey$SCH = fields[_runtime_types.ConfigKey.SCHEDULE]) === null || _fields$ConfigKey$SCH === void 0 ? void 0 : _fields$ConfigKey$SCH.number}${(_fields$ConfigKey$SCH2 = fields[_runtime_types.ConfigKey.SCHEDULE]) === null || _fields$ConfigKey$SCH2 === void 0 ? void 0 : _fields$ConfigKey$SCH2.unit}`;
  },
  [_runtime_types.ConfigKey.TAGS]: _formatting_utils.arrayFormatter
};
exports.commonFormatters = commonFormatters;