"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.browserFormatters = void 0;
var _formatters = require("../../../common/formatters/browser/formatters");
var _common = require("./common");
var _monitor_management = require("../../../common/runtime_types/monitor_management");
var _monitor_defaults = require("../../../common/constants/monitor_defaults");
var _tls = require("./tls");
var _formatting_utils = require("./formatting_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const throttlingFormatter = fields => {
  var _thValue$download, _thValue$upload, _thValue$latency;
  const value = fields[_monitor_management.ConfigKey.THROTTLING_CONFIG];
  const defaultThrottling = _monitor_defaults.DEFAULT_BROWSER_ADVANCED_FIELDS[_monitor_management.ConfigKey.THROTTLING_CONFIG].value;
  const thValue = value === null || value === void 0 ? void 0 : value.value;
  if (!thValue || !defaultThrottling) return false;
  if ((thValue === null || thValue === void 0 ? void 0 : thValue.download) === '0' && (thValue === null || thValue === void 0 ? void 0 : thValue.upload) === '0' && (thValue === null || thValue === void 0 ? void 0 : thValue.latency) === '0') return false;
  if ((value === null || value === void 0 ? void 0 : value.label) === 'no-throttling') return false;
  return {
    download: Number((_thValue$download = thValue === null || thValue === void 0 ? void 0 : thValue.download) !== null && _thValue$download !== void 0 ? _thValue$download : defaultThrottling.download),
    upload: Number((_thValue$upload = thValue === null || thValue === void 0 ? void 0 : thValue.upload) !== null && _thValue$upload !== void 0 ? _thValue$upload : defaultThrottling.upload),
    latency: Number((_thValue$latency = thValue === null || thValue === void 0 ? void 0 : thValue.latency) !== null && _thValue$latency !== void 0 ? _thValue$latency : defaultThrottling.latency)
  };
};
const browserFormatters = {
  ..._formatters.browserFormatters,
  [_monitor_management.ConfigKey.METADATA]: _formatting_utils.objectFormatter,
  [_monitor_management.ConfigKey.SOURCE_INLINE]: null,
  [_monitor_management.ConfigKey.THROTTLING_CONFIG]: throttlingFormatter,
  [_monitor_management.ConfigKey.JOURNEY_FILTERS_MATCH]: null,
  [_monitor_management.ConfigKey.SYNTHETICS_ARGS]: _formatting_utils.arrayFormatter,
  [_monitor_management.ConfigKey.JOURNEY_FILTERS_TAGS]: _formatting_utils.arrayFormatter,
  [_monitor_management.ConfigKey.PLAYWRIGHT_OPTIONS]: _formatting_utils.stringToObjectFormatter,
  ..._common.commonFormatters,
  ..._tls.tlsFormatters
};
exports.browserFormatters = browserFormatters;