"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSyntheticsEnablementRoute = exports.disableSyntheticsRoute = void 0;
var _service_api_key = require("../../legacy_uptime/lib/saved_objects/service_api_key");
var _constants = require("../../../common/constants");
var _get_api_key = require("../../synthetics_service/get_api_key");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSyntheticsEnablementRoute = libs => ({
  method: 'PUT',
  path: _constants.API_URLS.SYNTHETICS_ENABLEMENT,
  validate: {},
  handler: async ({
    savedObjectsClient,
    request,
    server
  }) => {
    try {
      var _server$config$servic, _server$config$servic2;
      const result = await libs.requests.getSyntheticsEnablement({
        server
      });
      const {
        canEnable,
        isEnabled
      } = result;
      const {
        security
      } = server;
      const {
        apiKey,
        isValid
      } = await libs.requests.getAPIKeyForSyntheticsService({
        server
      });
      if (apiKey && !isValid) {
        var _security$authc$apiKe;
        await _service_api_key.syntheticsServiceAPIKeySavedObject.delete(savedObjectsClient);
        await ((_security$authc$apiKe = security.authc.apiKeys) === null || _security$authc$apiKe === void 0 ? void 0 : _security$authc$apiKe.invalidateAsInternalUser({
          ids: [(apiKey === null || apiKey === void 0 ? void 0 : apiKey.id) || '']
        }));
      }
      const regenerationRequired = !isEnabled || !isValid;
      const shouldEnableApiKey = ((_server$config$servic = server.config.service) === null || _server$config$servic === void 0 ? void 0 : _server$config$servic.manifestUrl) || ((_server$config$servic2 = server.config.service) === null || _server$config$servic2 === void 0 ? void 0 : _server$config$servic2.devUrl);
      if (canEnable && regenerationRequired && shouldEnableApiKey) {
        await (0, _get_api_key.generateAndSaveServiceAPIKey)({
          request,
          authSavedObjectsClient: savedObjectsClient,
          server
        });
      } else {
        return result;
      }
      return libs.requests.getSyntheticsEnablement({
        server
      });
    } catch (e) {
      server.logger.error(e);
      throw e;
    }
  }
});
exports.getSyntheticsEnablementRoute = getSyntheticsEnablementRoute;
const disableSyntheticsRoute = libs => ({
  method: 'DELETE',
  path: _constants.API_URLS.SYNTHETICS_ENABLEMENT,
  validate: {},
  handler: async ({
    response,
    request,
    server,
    syntheticsMonitorClient,
    savedObjectsClient
  }) => {
    const {
      security
    } = server;
    const {
      syntheticsService
    } = syntheticsMonitorClient;
    try {
      var _security$authc$apiKe2;
      const {
        canEnable
      } = await libs.requests.getSyntheticsEnablement({
        server
      });
      if (!canEnable) {
        return response.forbidden();
      }
      await syntheticsService.deleteAllConfigs();
      const {
        apiKey
      } = await libs.requests.getAPIKeyForSyntheticsService({
        server
      });
      await _service_api_key.syntheticsServiceAPIKeySavedObject.delete(savedObjectsClient);
      await ((_security$authc$apiKe2 = security.authc.apiKeys) === null || _security$authc$apiKe2 === void 0 ? void 0 : _security$authc$apiKe2.invalidateAsInternalUser({
        ids: [(apiKey === null || apiKey === void 0 ? void 0 : apiKey.id) || '']
      }));
      return response.ok({});
    } catch (e) {
      server.logger.error(e);
      throw e;
    }
  }
});
exports.disableSyntheticsRoute = disableSyntheticsRoute;