"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deletePrivateLocationRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _get_private_locations = require("./get_private_locations");
var _constants = require("../../../../common/constants");
var _private_locations = require("../../../../common/saved_objects/private_locations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deletePrivateLocationRoute = () => ({
  method: 'DELETE',
  path: _constants.SYNTHETICS_API_URLS.PRIVATE_LOCATIONS + '/{locationId}',
  validate: {
    params: _configSchema.schema.object({
      locationId: _configSchema.schema.string({
        minLength: 1,
        maxLength: 1024
      })
    })
  },
  writeAccess: true,
  handler: async ({
    savedObjectsClient,
    request,
    server
  }) => {
    const {
      locationId
    } = request.params;
    const {
      locations
    } = await (0, _get_private_locations.getAllPrivateLocations)(savedObjectsClient);
    const remainingLocations = locations.filter(loc => loc.id !== locationId);
    const result = await savedObjectsClient.create(_private_locations.privateLocationsSavedObjectName, {
      locations: remainingLocations
    }, {
      id: _private_locations.privateLocationsSavedObjectId,
      overwrite: true
    });
    return result.attributes;
  }
});
exports.deletePrivateLocationRoute = deletePrivateLocationRoute;