"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSyntheticsMonitorRoute = exports.getSyntheticsMonitorOverviewRoute = exports.getAllSyntheticsMonitorRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _server = require("@kbn/core/server");
var _get_all_monitors = require("../../saved_objects/synthetics_monitor/get_all_monitors");
var _alert_config = require("../../../common/runtime_types/monitor_management/alert_config");
var _runtime_types = require("../../../common/runtime_types");
var _constants = require("../../../common/constants");
var _synthetics_monitor = require("../../legacy_uptime/lib/saved_objects/synthetics_monitor");
var _service_errors = require("../synthetics_service/service_errors");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSyntheticsMonitorRoute = libs => ({
  method: 'GET',
  path: _constants.API_URLS.SYNTHETICS_MONITORS + '/{monitorId}',
  validate: {
    params: _configSchema.schema.object({
      monitorId: _configSchema.schema.string({
        minLength: 1,
        maxLength: 1024
      })
    })
  },
  handler: async ({
    request,
    response,
    server: {
      encryptedSavedObjects
    },
    savedObjectsClient
  }) => {
    const {
      monitorId
    } = request.params;
    const encryptedSavedObjectsClient = encryptedSavedObjects.getClient();
    try {
      return await libs.requests.getSyntheticsMonitor({
        monitorId,
        encryptedSavedObjectsClient,
        savedObjectsClient
      });
    } catch (getErr) {
      if (_server.SavedObjectsErrorHelpers.isNotFoundError(getErr)) {
        return (0, _service_errors.getMonitorNotFoundResponse)(response, monitorId);
      }
      throw getErr;
    }
  }
});
exports.getSyntheticsMonitorRoute = getSyntheticsMonitorRoute;
const getAllSyntheticsMonitorRoute = () => ({
  method: 'GET',
  path: _constants.API_URLS.SYNTHETICS_MONITORS,
  validate: {
    query: _common.QuerySchema
  },
  handler: async routeContext => {
    var _totalCount$total;
    const {
      request,
      savedObjectsClient,
      syntheticsMonitorClient
    } = routeContext;
    const totalCountQuery = async () => {
      if ((0, _common.isMonitorsQueryFiltered)(request.query)) {
        return savedObjectsClient.find({
          type: _synthetics_monitor.syntheticsMonitorType,
          perPage: 0,
          page: 1
        });
      }
    };
    const [queryResult, totalCount] = await Promise.all([(0, _common.getMonitors)(routeContext), totalCountQuery()]);
    const absoluteTotal = (_totalCount$total = totalCount === null || totalCount === void 0 ? void 0 : totalCount.total) !== null && _totalCount$total !== void 0 ? _totalCount$total : queryResult.total;
    const {
      saved_objects: monitors,
      per_page: perPageT,
      ...rest
    } = queryResult;
    return {
      ...rest,
      monitors,
      absoluteTotal,
      perPage: perPageT,
      syncErrors: syntheticsMonitorClient.syntheticsService.syncErrors
    };
  }
});
exports.getAllSyntheticsMonitorRoute = getAllSyntheticsMonitorRoute;
const getSyntheticsMonitorOverviewRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.SYNTHETICS_OVERVIEW,
  validate: {
    query: _common.QuerySchema
  },
  handler: async routeContext => {
    const {
      request,
      savedObjectsClient
    } = routeContext;
    const {
      sortField,
      sortOrder,
      query,
      locations: queriedLocations
    } = request.query;
    const filtersStr = await (0, _common.getMonitorFilters)({
      ...request.query,
      context: routeContext
    });
    const allMonitorConfigs = await (0, _get_all_monitors.getAllMonitors)({
      sortOrder,
      filter: filtersStr,
      soClient: savedObjectsClient,
      sortField: sortField === 'status' ? `${_runtime_types.ConfigKey.NAME}.keyword` : sortField,
      search: query ? `${query}*` : undefined,
      searchFields: _common.SEARCH_FIELDS
    });
    const allMonitorIds = [];
    let total = 0;
    const allMonitors = [];
    for (const {
      attributes
    } of allMonitorConfigs) {
      const configId = attributes[_runtime_types.ConfigKey.CONFIG_ID];
      allMonitorIds.push(configId);
      const monitorConfigsPerLocation = getOverviewConfigsPerLocation(attributes, queriedLocations);
      allMonitors.push(...monitorConfigsPerLocation);
      total += monitorConfigsPerLocation.length;
    }
    return {
      monitors: allMonitors,
      total,
      allMonitorIds
    };
  }
});
exports.getSyntheticsMonitorOverviewRoute = getSyntheticsMonitorOverviewRoute;
function getOverviewConfigsPerLocation(attributes, queriedLocations) {
  const id = attributes[_runtime_types.ConfigKey.MONITOR_QUERY_ID];
  const configId = attributes[_runtime_types.ConfigKey.CONFIG_ID];

  /* for each location, add a config item */
  const locations = attributes[_runtime_types.ConfigKey.LOCATIONS];
  const queriedLocationsArray = queriedLocations && !Array.isArray(queriedLocations) ? [queriedLocations] : queriedLocations;

  /* exclude nob matching locations if location filter is present */
  const filteredLocations = queriedLocationsArray !== null && queriedLocationsArray !== void 0 && queriedLocationsArray.length ? locations.filter(loc => loc.label && queriedLocationsArray.includes(loc.label) || queriedLocationsArray.includes(loc.id)) : locations;
  return filteredLocations.map(location => ({
    id,
    configId,
    location,
    name: attributes[_runtime_types.ConfigKey.NAME],
    tags: attributes[_runtime_types.ConfigKey.TAGS],
    isEnabled: attributes[_runtime_types.ConfigKey.ENABLED],
    type: attributes[_runtime_types.ConfigKey.MONITOR_TYPE],
    projectId: attributes[_runtime_types.ConfigKey.PROJECT_ID],
    isStatusAlertEnabled: (0, _alert_config.isStatusEnabled)(attributes[_runtime_types.ConfigKey.ALERT_CONFIG])
  }));
}