"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusAlertService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _saved_objects = require("../../legacy_uptime/lib/saved_objects");
var _alert_actions = require("../../../common/rules/alert_actions");
var _translations = require("../../../common/rules/synthetics/translations");
var _synthetics_alerts = require("../../../common/constants/synthetics_alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class StatusAlertService {
  constructor(context, server, soClient) {
    (0, _defineProperty2.default)(this, "context", void 0);
    (0, _defineProperty2.default)(this, "soClient", void 0);
    (0, _defineProperty2.default)(this, "server", void 0);
    this.context = context;
    this.server = server;
    this.soClient = soClient;
  }
  async getExistingAlert() {
    var _await$this$context$a;
    const rulesClient = (_await$this$context$a = await this.context.alerting) === null || _await$this$context$a === void 0 ? void 0 : _await$this$context$a.getRulesClient();
    const {
      data
    } = await rulesClient.find({
      options: {
        page: 1,
        perPage: 1,
        filter: `alert.attributes.alertTypeId:(${_synthetics_alerts.SYNTHETICS_ALERT_RULE_TYPES.MONITOR_STATUS})`
      }
    });
    const alert = data === null || data === void 0 ? void 0 : data[0];
    if (!alert) {
      return;
    }
    return {
      ...alert,
      ruleTypeId: alert.alertTypeId
    };
  }
  async createDefaultAlertIfNotExist() {
    var _await$this$context$a2;
    const alert = await this.getExistingAlert();
    if (alert) {
      return alert;
    }
    const actions = await this.getAlertActions();
    const rulesClient = (_await$this$context$a2 = await this.context.alerting) === null || _await$this$context$a2 === void 0 ? void 0 : _await$this$context$a2.getRulesClient();
    const newAlert = await rulesClient.create({
      data: {
        actions,
        params: {},
        consumer: 'uptime',
        alertTypeId: _synthetics_alerts.SYNTHETICS_ALERT_RULE_TYPES.MONITOR_STATUS,
        schedule: {
          interval: '1m'
        },
        notifyWhen: 'onActionGroupChange',
        tags: ['SYNTHETICS_DEFAULT_ALERT'],
        name: `Synthetics internal alert`,
        enabled: true,
        throttle: null
      }
    });
    return {
      ...newAlert,
      ruleTypeId: newAlert.alertTypeId
    };
  }
  async updateDefaultAlert() {
    var _await$this$context$a3;
    const rulesClient = (_await$this$context$a3 = await this.context.alerting) === null || _await$this$context$a3 === void 0 ? void 0 : _await$this$context$a3.getRulesClient();
    const alert = await this.getExistingAlert();
    if (alert) {
      const actions = await this.getAlertActions();
      const updatedAlert = await rulesClient.update({
        id: alert.id,
        data: {
          actions,
          name: alert.name,
          tags: alert.tags,
          schedule: alert.schedule,
          params: alert.params,
          notifyWhen: alert.notifyWhen
        }
      });
      return {
        ...updatedAlert,
        ruleTypeId: updatedAlert.alertTypeId
      };
    }
    return await this.createDefaultAlertIfNotExist();
  }
  async getAlertActions() {
    const {
      actionConnectors,
      settings
    } = await this.getActionConnectors();
    const defaultActions = (actionConnectors !== null && actionConnectors !== void 0 ? actionConnectors : []).filter(act => {
      var _settings$defaultConn;
      return settings === null || settings === void 0 ? void 0 : (_settings$defaultConn = settings.defaultConnectors) === null || _settings$defaultConn === void 0 ? void 0 : _settings$defaultConn.includes(act.id);
    });
    return (0, _alert_actions.populateAlertActions)({
      groupId: _synthetics_alerts.ACTION_GROUP_DEFINITIONS.MONITOR_STATUS.id,
      defaultActions,
      defaultEmail: settings === null || settings === void 0 ? void 0 : settings.defaultEmail,
      translations: {
        defaultActionMessage: _translations.SyntheticsMonitorStatusTranslations.defaultActionMessage,
        defaultRecoveryMessage: _translations.SyntheticsMonitorStatusTranslations.defaultRecoveryMessage,
        defaultSubjectMessage: _translations.SyntheticsMonitorStatusTranslations.defaultSubjectMessage,
        defaultRecoverySubjectMessage: _translations.SyntheticsMonitorStatusTranslations.defaultRecoverySubjectMessage
      }
    });
  }
  async getActionConnectors() {
    var _await$this$context$a4;
    const actionsClient = (_await$this$context$a4 = await this.context.actions) === null || _await$this$context$a4 === void 0 ? void 0 : _await$this$context$a4.getActionsClient();
    const settings = await _saved_objects.savedObjectsAdapter.getUptimeDynamicSettings(this.soClient);
    let actionConnectors = [];
    try {
      actionConnectors = await actionsClient.getAll();
    } catch (e) {
      this.server.logger.error(e);
    }
    return {
      actionConnectors,
      settings
    };
  }
}
exports.StatusAlertService = StatusAlertService;