"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultAlertingRoute = void 0;
var _status_alert_service = require("./status_alert_service");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultAlertingRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.ENABLE_DEFAULT_ALERTING,
  validate: {},
  handler: async ({
    context,
    server,
    savedObjectsClient
  }) => {
    const statusAlertService = new _status_alert_service.StatusAlertService(context, server, savedObjectsClient);
    return await statusAlertService.getExistingAlert();
  }
});
exports.getDefaultAlertingRoute = getDefaultAlertingRoute;