"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uptimeRouteWrapper = void 0;
var _coreHttpRouterServerInternal = require("@kbn/core-http-router-server-internal");
var _check_has_privilege = require("../../synthetics_service/authentication/check_has_privilege");
var _lib = require("../lib/lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const uptimeRouteWrapper = (uptimeRoute, server) => ({
  ...uptimeRoute,
  options: {
    tags: ['access:uptime-read', ...(uptimeRoute !== null && uptimeRoute !== void 0 && uptimeRoute.writeAccess ? ['access:uptime-write'] : [])]
  },
  handler: async (context, request, response) => {
    const coreContext = await context.core;
    const {
      client: esClient
    } = coreContext.elasticsearch;
    server.authSavedObjectsClient = coreContext.savedObjects.client;
    const uptimeEsClient = new _lib.UptimeEsClient(coreContext.savedObjects.client, esClient.asCurrentUser, {
      request,
      uiSettings: coreContext.uiSettings,
      isDev: Boolean(server.isDev && !(0, _lib.isTestUser)(server))
    });
    server.uptimeEsClient = uptimeEsClient;
    try {
      const res = await uptimeRoute.handler({
        uptimeEsClient,
        savedObjectsClient: coreContext.savedObjects.client,
        context,
        request,
        response,
        server
      });
      if (res instanceof _coreHttpRouterServerInternal.KibanaResponse) {
        return res;
      }
      return response.ok({
        body: {
          ...res,
          ...(await uptimeEsClient.getInspectData(uptimeRoute.path))
        }
      });
    } catch (e) {
      if (e.statusCode === 403) {
        const privileges = await (0, _check_has_privilege.checkIndicesReadPrivileges)(uptimeEsClient);
        if (!privileges.has_all_requested) {
          return response.forbidden({
            body: {
              message: `MissingIndicesPrivileges: You do not have permission to read from the ${uptimeEsClient.heartbeatIndices}  indices. Please contact your administrator.`
            }
          });
        }
      }
      throw e;
    }
  }
});
exports.uptimeRouteWrapper = uptimeRouteWrapper;