"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.syntheticsSelector = exports.selectedFiltersSelector = exports.selectPingList = exports.selectPingHistogram = exports.selectDynamicSettings = exports.selectDurationLines = exports.selectAlertFlyoutVisibility = exports.selectAlertFlyoutType = exports.searchTextSelector = exports.networkEventsSelector = exports.monitorStatusSelector = exports.monitorLocationsSelector = exports.monitorListSelector = exports.monitorIdSelector = exports.monitorDetailsSelector = exports.monitorDetailsLoadingSelector = exports.mlCapabilitiesSelector = exports.journeySelector = exports.isMLJobDeletingSelector = exports.isMLJobDeletedSelector = exports.isMLJobCreatingSelector = exports.isIntegrationsPopupOpen = exports.indexStatusSelector = exports.hasNewMLJobSelector = exports.hasMLJobSelector = exports.hasMLFeatureSelector = exports.getBasePath = exports.esKuerySelector = exports.canDeleteMLJobSelector = exports.canCreateMLJobSelector = exports.anomaliesSelector = void 0;
var _reselect = require("reselect");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// UI Selectors
const getBasePath = ({
  ui: {
    basePath
  }
}) => basePath;
exports.getBasePath = getBasePath;
const isIntegrationsPopupOpen = ({
  ui: {
    integrationsPopoverOpen
  }
}) => integrationsPopoverOpen;

// Monitor Selectors
exports.isIntegrationsPopupOpen = isIntegrationsPopupOpen;
const monitorDetailsSelector = (state, summary) => {
  return state.monitor.monitorDetailsList[summary.monitor_id];
};
exports.monitorDetailsSelector = monitorDetailsSelector;
const monitorDetailsLoadingSelector = state => state.monitor.loading;
exports.monitorDetailsLoadingSelector = monitorDetailsLoadingSelector;
const monitorLocationsSelector = (state, monitorId) => {
  var _state$monitor$monito;
  return (_state$monitor$monito = state.monitor.monitorLocationsList) === null || _state$monitor$monito === void 0 ? void 0 : _state$monitor$monito.get(monitorId);
};
exports.monitorLocationsSelector = monitorLocationsSelector;
const monitorStatusSelector = state => state.monitorStatus.status;
exports.monitorStatusSelector = monitorStatusSelector;
const selectDynamicSettings = state => state.dynamicSettings;
exports.selectDynamicSettings = selectDynamicSettings;
const selectPingHistogram = ({
  ping
}) => ping;
exports.selectPingHistogram = selectPingHistogram;
const selectPingList = ({
  pingList
}) => pingList;
exports.selectPingList = selectPingList;
const mlCapabilitiesSelector = state => state.ml.mlCapabilities;
exports.mlCapabilitiesSelector = mlCapabilitiesSelector;
const hasMLFeatureSelector = (0, _reselect.createSelector)(mlCapabilitiesSelector, mlCapabilities => {
  var _mlCapabilities$data, _mlCapabilities$data2;
  return (mlCapabilities === null || mlCapabilities === void 0 ? void 0 : (_mlCapabilities$data = mlCapabilities.data) === null || _mlCapabilities$data === void 0 ? void 0 : _mlCapabilities$data.isPlatinumOrTrialLicense) && (mlCapabilities === null || mlCapabilities === void 0 ? void 0 : (_mlCapabilities$data2 = mlCapabilities.data) === null || _mlCapabilities$data2 === void 0 ? void 0 : _mlCapabilities$data2.mlFeatureEnabledInSpace);
});
exports.hasMLFeatureSelector = hasMLFeatureSelector;
const canCreateMLJobSelector = (0, _reselect.createSelector)(mlCapabilitiesSelector, mlCapabilities => {
  var _mlCapabilities$data3, _mlCapabilities$data4;
  return mlCapabilities === null || mlCapabilities === void 0 ? void 0 : (_mlCapabilities$data3 = mlCapabilities.data) === null || _mlCapabilities$data3 === void 0 ? void 0 : (_mlCapabilities$data4 = _mlCapabilities$data3.capabilities) === null || _mlCapabilities$data4 === void 0 ? void 0 : _mlCapabilities$data4.canCreateJob;
});
exports.canCreateMLJobSelector = canCreateMLJobSelector;
const canDeleteMLJobSelector = (0, _reselect.createSelector)(mlCapabilitiesSelector, mlCapabilities => {
  var _mlCapabilities$data5, _mlCapabilities$data6;
  return mlCapabilities === null || mlCapabilities === void 0 ? void 0 : (_mlCapabilities$data5 = mlCapabilities.data) === null || _mlCapabilities$data5 === void 0 ? void 0 : (_mlCapabilities$data6 = _mlCapabilities$data5.capabilities) === null || _mlCapabilities$data6 === void 0 ? void 0 : _mlCapabilities$data6.canDeleteJob;
});
exports.canDeleteMLJobSelector = canDeleteMLJobSelector;
const hasMLJobSelector = ({
  ml
}) => ml.mlJob;
exports.hasMLJobSelector = hasMLJobSelector;
const hasNewMLJobSelector = ({
  ml
}) => ml.createJob;
exports.hasNewMLJobSelector = hasNewMLJobSelector;
const isMLJobCreatingSelector = ({
  ml
}) => ml.createJob.loading;
exports.isMLJobCreatingSelector = isMLJobCreatingSelector;
const isMLJobDeletingSelector = ({
  ml
}) => ml.deleteJob.loading;
exports.isMLJobDeletingSelector = isMLJobDeletingSelector;
const isMLJobDeletedSelector = ({
  ml
}) => ml.deleteJob;
exports.isMLJobDeletedSelector = isMLJobDeletedSelector;
const anomaliesSelector = ({
  ml
}) => ml.anomalies.data;
exports.anomaliesSelector = anomaliesSelector;
const selectDurationLines = ({
  monitorDuration
}) => monitorDuration;
exports.selectDurationLines = selectDurationLines;
const selectAlertFlyoutVisibility = ({
  ui: {
    alertFlyoutVisible
  }
}) => alertFlyoutVisible;
exports.selectAlertFlyoutVisibility = selectAlertFlyoutVisibility;
const selectAlertFlyoutType = ({
  ui: {
    alertFlyoutType
  }
}) => alertFlyoutType;
exports.selectAlertFlyoutType = selectAlertFlyoutType;
const indexStatusSelector = ({
  indexStatus
}) => indexStatus.indexStatus;
exports.indexStatusSelector = indexStatusSelector;
const monitorListSelector = ({
  monitorList
}) => monitorList;
exports.monitorListSelector = monitorListSelector;
const esKuerySelector = ({
  ui: {
    esKuery
  }
}) => esKuery;
exports.esKuerySelector = esKuerySelector;
const searchTextSelector = ({
  ui: {
    searchText
  }
}) => searchText;
exports.searchTextSelector = searchTextSelector;
const selectedFiltersSelector = ({
  selectedFilters
}) => selectedFilters;
exports.selectedFiltersSelector = selectedFiltersSelector;
const monitorIdSelector = ({
  ui: {
    monitorId
  }
}) => monitorId;
exports.monitorIdSelector = monitorIdSelector;
const journeySelector = ({
  journeys
}) => journeys;
exports.journeySelector = journeySelector;
const networkEventsSelector = ({
  networkEvents
}) => networkEvents;
exports.networkEventsSelector = networkEventsSelector;
const syntheticsSelector = ({
  synthetics
}) => synthetics;
exports.syntheticsSelector = syntheticsSelector;