"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.monitorReducer = monitorReducer;
var _monitor = require("../actions/monitor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  monitorDetailsList: [],
  monitorLocationsList: new Map(),
  loading: false,
  errors: []
};
function monitorReducer(state = initialState, action) {
  switch (action.type) {
    case String(_monitor.getMonitorDetailsAction.get):
      return {
        ...state,
        loading: true
      };
    case String(_monitor.getMonitorDetailsAction.success):
      const {
        monitorId
      } = action.payload;
      return {
        ...state,
        monitorDetailsList: {
          ...state.monitorDetailsList,
          [monitorId]: action.payload
        },
        loading: false
      };
    case String(_monitor.getMonitorDetailsAction.fail):
      return {
        ...state,
        errors: [...state.errors, action.payload],
        loading: false
      };
    case String(_monitor.getMonitorLocationsAction):
      return {
        ...state,
        loading: true
      };
    case String(_monitor.getMonitorLocationsActionSuccess):
      const monLocations = state.monitorLocationsList;
      monLocations.set(action.payload.monitorId, action.payload);
      return {
        ...state,
        monitorLocationsList: monLocations,
        loading: false
      };
    case String(_monitor.getMonitorLocationsActionFail):
      return {
        ...state,
        errors: [...state.errors, action.payload]
      };
    default:
      return state;
  }
}