"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchEffectFactory = fetchEffectFactory;
var _effects = require("redux-saga/effects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Factory function for a fetch effect. It expects three action creators,
 * one to call for a fetch, one to call for success, and one to handle failures.
 * @param fetch creates a fetch action
 * @param success creates a success action
 * @param fail creates a failure action
 * @template T the action type expected by the fetch action
 * @template R the type that the API request should return on success
 * @template S the type of the success action
 * @template F the type of the failure action
 */
function fetchEffectFactory(fetch, success, fail) {
  return function* (action) {
    try {
      const response = yield (0, _effects.call)(fetch, action.payload);
      if (response instanceof Error) {
        // eslint-disable-next-line no-console
        console.error(response);
        yield (0, _effects.put)(fail(response));
      } else {
        yield (0, _effects.put)(success(response));
      }
    } catch (error) {
      // eslint-disable-next-line no-console
      console.error(error);
      yield (0, _effects.put)(fail(error));
    }
  };
}