"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchDynamicSettingsEffect = fetchDynamicSettingsEffect;
exports.setDynamicSettingsEffect = setDynamicSettingsEffect;
var _effects = require("redux-saga/effects");
var _i18n = require("@kbn/i18n");
var _fetch_effect = require("./fetch_effect");
var _dynamic_settings = require("../actions/dynamic_settings");
var _api = require("../api");
var _kibana_service = require("../kibana_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function* fetchDynamicSettingsEffect() {
  yield (0, _effects.takeLeading)(String(_dynamic_settings.getDynamicSettings), (0, _fetch_effect.fetchEffectFactory)(_api.getDynamicSettings, _dynamic_settings.getDynamicSettingsSuccess, _dynamic_settings.getDynamicSettingsFail));
}
function* setDynamicSettingsEffect() {
  const couldNotSaveSettingsText = _i18n.i18n.translate('xpack.synthetics.settings.error.couldNotSave', {
    defaultMessage: 'Could not save settings!'
  });
  yield (0, _effects.takeLatest)(String(_dynamic_settings.setDynamicSettings), function* (action) {
    try {
      if (!action.payload) {
        const err = new Error('Cannot fetch effect without a payload');
        yield (0, _effects.put)((0, _dynamic_settings.setDynamicSettingsFail)(err));
        _kibana_service.kibanaService.core.notifications.toasts.addError(err, {
          title: couldNotSaveSettingsText
        });
        return;
      }
      yield (0, _effects.call)(_api.setDynamicSettings, {
        settings: action.payload
      });
      yield (0, _effects.put)((0, _dynamic_settings.setDynamicSettingsSuccess)(action.payload));
      _kibana_service.kibanaService.core.notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.synthetics.settings.saveSuccess', {
        defaultMessage: 'Settings saved!'
      }));
    } catch (err) {
      _kibana_service.kibanaService.core.notifications.toasts.addError(err, {
        title: couldNotSaveSettingsText
      });
      yield (0, _effects.put)((0, _dynamic_settings.setDynamicSettingsFail)(err));
    }
  });
}