"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageRouter = exports.MONITORING_OVERVIEW_LABEL = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/observability-plugin/public");
var _constants = require("../../common/constants");
var _pages = require("./pages");
var _certificates = require("./pages/certificates");
var _hooks = require("./hooks");
var _overview = require("./pages/overview");
var _synthetics_checks = require("./pages/synthetics/synthetics_checks");
var _monitor_title = require("./components/monitor/monitor_title");
var _uptime_date_picker = require("./components/common/uptime_date_picker");
var _cert_refresh_btn = require("./components/certificates/cert_refresh_btn");
var _certificate_title = require("./components/certificates/certificate_title");
var _step_detail_page = require("./pages/synthetics/step_detail_page");
var _uptime_page_template = require("./app/uptime_page_template");
var _utils = require("./state/api/utils");
var _settings_bottom_bar = require("./components/settings/settings_bottom_bar");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const baseTitle = _i18n.i18n.translate('xpack.synthetics.routes.legacyBaseTitle', {
  defaultMessage: 'Uptime - Kibana'
});
const MONITORING_OVERVIEW_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.heading', {
  defaultMessage: 'Monitors'
});
exports.MONITORING_OVERVIEW_LABEL = MONITORING_OVERVIEW_LABEL;
const getRoutes = () => {
  return [{
    title: _i18n.i18n.translate('xpack.synthetics.monitorRoute.title', {
      defaultMessage: 'Monitor | {baseTitle}',
      values: {
        baseTitle
      }
    }),
    path: _constants.MONITOR_ROUTE,
    component: _pages.MonitorPage,
    dataTestSubj: 'uptimeMonitorPage',
    telemetryId: _hooks.UptimePage.Monitor,
    pageHeader: {
      children: /*#__PURE__*/_react.default.createElement(_monitor_title.MonitorPageTitleContent, null),
      pageTitle: /*#__PURE__*/_react.default.createElement(_monitor_title.MonitorPageTitle, null),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_uptime_date_picker.UptimeDatePicker, null)]
    }
  }, {
    title: _i18n.i18n.translate('xpack.synthetics.settingsRoute.title', {
      defaultMessage: `Settings | {baseTitle}`,
      values: {
        baseTitle
      }
    }),
    path: _constants.SETTINGS_ROUTE,
    component: _pages.SettingsPage,
    dataTestSubj: 'uptimeSettingsPage',
    telemetryId: _hooks.UptimePage.Settings,
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.settings.heading",
        defaultMessage: "Uptime settings"
      })
    },
    bottomBar: /*#__PURE__*/_react.default.createElement(_settings_bottom_bar.SettingsBottomBar, null),
    bottomBarProps: {
      paddingSize: 'm'
    }
  }, {
    title: _i18n.i18n.translate('xpack.synthetics.certificatesRoute.title', {
      defaultMessage: `Certificates | {baseTitle}`,
      values: {
        baseTitle
      }
    }),
    path: _constants.CERTIFICATES_ROUTE,
    component: _certificates.CertificatesPage,
    dataTestSubj: 'uptimeCertificatesPage',
    telemetryId: _hooks.UptimePage.Certificates,
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement(_certificate_title.CertificateTitle, null),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_cert_refresh_btn.CertRefreshBtn, null)]
    }
  }, {
    title: _i18n.i18n.translate('xpack.synthetics.stepDetailRoute.title', {
      defaultMessage: 'Synthetics detail | {baseTitle}',
      values: {
        baseTitle
      }
    }),
    path: _constants.STEP_DETAIL_ROUTE,
    component: _pages.StepDetailPage,
    dataTestSubj: 'uptimeStepDetailPage',
    telemetryId: _hooks.UptimePage.StepDetail,
    pageHeader: {
      children: /*#__PURE__*/_react.default.createElement(_step_detail_page.StepDetailPageChildren, null),
      pageTitle: /*#__PURE__*/_react.default.createElement(_step_detail_page.StepDetailPageHeader, null),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_step_detail_page.StepDetailPageRightSideItem, null)]
    }
  }, {
    title: baseTitle,
    path: _constants.SYNTHETIC_CHECK_STEPS_ROUTE,
    component: _synthetics_checks.SyntheticsCheckSteps,
    dataTestSubj: 'uptimeSyntheticCheckStepsPage',
    telemetryId: _hooks.UptimePage.SyntheticCheckStepsPage,
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement(_synthetics_checks.SyntheticsCheckStepsPageHeader, null),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_synthetics_checks.SyntheticsCheckStepsPageRightSideItem, null)]
    }
  }, {
    title: baseTitle,
    path: _constants.OVERVIEW_ROUTE,
    component: _overview.OverviewPageComponent,
    dataTestSubj: 'uptimeOverviewPage',
    telemetryId: _hooks.UptimePage.Overview,
    pageHeader: {
      pageTitle: MONITORING_OVERVIEW_LABEL,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_uptime_date_picker.UptimeDatePicker, null)]
    }
  }, {
    title: _i18n.i18n.translate('xpack.synthetics.mappingErrorRoute.title', {
      defaultMessage: 'Synthetics | mapping error'
    }),
    path: _constants.MAPPING_ERROR_ROUTE,
    component: _pages.MappingErrorPage,
    dataTestSubj: 'uptimeMappingErrorPage',
    telemetryId: _hooks.UptimePage.MappingError,
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.mappingErrorRoute.pageHeader.title",
        defaultMessage: "Mapping error"
      })),
      rightSideItems: []
    }
  }];
};
const RouteInit = ({
  path,
  title,
  telemetryId
}) => {
  (0, _hooks.useUptimeTelemetry)(telemetryId);
  (0, _react.useEffect)(() => {
    document.title = title;
  }, [path, title]);
  return null;
};
const PageRouter = () => {
  const routes = getRoutes();
  const {
    addInspectorRequest
  } = (0, _public2.useInspectorContext)();
  _utils.apiService.addInspectorRequest = addInspectorRequest;
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, routes.map(({
    title,
    path,
    component: RouteComponent,
    dataTestSubj,
    telemetryId,
    pageHeader,
    ...pageTemplateProps
  }) => /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: path,
    key: telemetryId,
    exact: true
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: _public.APP_WRAPPER_CLASS,
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(RouteInit, {
    title: title,
    path: path,
    telemetryId: telemetryId
  }), /*#__PURE__*/_react.default.createElement(_uptime_page_template.UptimePageTemplateComponent, (0, _extends2.default)({
    path: path,
    pageHeader: pageHeader
  }, pageTemplateProps), /*#__PURE__*/_react.default.createElement(RouteComponent, null))))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _pages.NotFoundPage
  }));
};
exports.PageRouter = PageRouter;