"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.settings = exports.SPACE_STR = exports.REFRESH_CERT = exports.BLANK_STR = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REFRESH_CERT = _i18n.i18n.translate('xpack.synthetics.certificates.refresh', {
  defaultMessage: 'Refresh'
});
exports.REFRESH_CERT = REFRESH_CERT;
const settings = {
  breadcrumbText: _i18n.i18n.translate('xpack.synthetics.settingsBreadcrumbText', {
    defaultMessage: 'Settings'
  }),
  editNoticeTitle: _i18n.i18n.translate('xpack.synthetics.settings.cannotEditTitle', {
    defaultMessage: 'You do not have permission to edit settings.'
  }),
  editNoticeText: _i18n.i18n.translate('xpack.synthetics.settings.cannotEditText', {
    defaultMessage: "Your user currently has 'Read' permissions for the Uptime app. Enable a permissions-level of 'All' to edit these settings."
  }),
  mustBeNumber: _i18n.i18n.translate('xpack.synthetics.settings.blankNumberField.error', {
    defaultMessage: 'Must be a number.'
  })
};
exports.settings = settings;
const BLANK_STR = _i18n.i18n.translate('xpack.synthetics.settings.blank.error', {
  defaultMessage: 'May not be blank.'
});
exports.BLANK_STR = BLANK_STR;
const SPACE_STR = _i18n.i18n.translate('xpack.synthetics.settings.noSpace.error', {
  defaultMessage: 'Index names must not contain space'
});
exports.SPACE_STR = SPACE_STR;