"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyntheticsCheckStepsPageRightSideItem = exports.SyntheticsCheckStepsPageHeader = exports.SyntheticsCheckSteps = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-plugin/public");
var _use_init_app = require("../../hooks/use_init_app");
var _steps_list = require("../../components/synthetics/check_steps/steps_list");
var _use_check_steps = require("../../components/synthetics/check_steps/use_check_steps");
var _checks_navigation = require("./checks_navigation");
var _use_monitor_breadcrumb = require("../../components/monitor/synthetics/step_detail/use_monitor_breadcrumb");
var _empty_journey = require("../../components/synthetics/empty_journey");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SyntheticsCheckStepsPageHeader = () => {
  var _details$journey, _details$journey2;
  const {
    details
  } = (0, _use_check_steps.useCheckSteps)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (details === null || details === void 0 ? void 0 : (_details$journey = details.journey) === null || _details$journey === void 0 ? void 0 : _details$journey.monitor.name) || (details === null || details === void 0 ? void 0 : (_details$journey2 = details.journey) === null || _details$journey2 === void 0 ? void 0 : _details$journey2.monitor.id));
};
exports.SyntheticsCheckStepsPageHeader = SyntheticsCheckStepsPageHeader;
const SyntheticsCheckStepsPageRightSideItem = () => {
  const {
    details
  } = (0, _use_check_steps.useCheckSteps)();
  if (!details) return null;
  return /*#__PURE__*/_react.default.createElement(_checks_navigation.ChecksNavigation, {
    timestamp: details.timestamp,
    details: details
  });
};
exports.SyntheticsCheckStepsPageRightSideItem = SyntheticsCheckStepsPageRightSideItem;
const SyntheticsCheckSteps = () => {
  (0, _use_init_app.useInitApp)();
  (0, _public.useTrackPageview)({
    app: 'uptime',
    path: 'syntheticCheckSteps'
  });
  (0, _public.useTrackPageview)({
    app: 'uptime',
    path: 'syntheticCheckSteps',
    delay: 15000
  });
  const {
    error,
    loading,
    steps,
    details,
    checkGroup
  } = (0, _use_check_steps.useCheckSteps)();
  (0, _use_monitor_breadcrumb.useMonitorBreadcrumb)({
    details,
    activeStep: details === null || details === void 0 ? void 0 : details.journey
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_steps_list.StepsList, {
    data: steps,
    loading: loading,
    allStepsLoaded: !loading,
    error: error
  }), (!steps || steps.length === 0) && !loading && /*#__PURE__*/_react.default.createElement(_empty_journey.EmptyJourney, {
    checkGroup: checkGroup
  }));
};
exports.SyntheticsCheckSteps = SyntheticsCheckSteps;