"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewPageComponent = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _public = require("@kbn/observability-plugin/public");
var _use_breadcrumbs = require("../hooks/use_breadcrumbs");
var _monitor_list_container = require("../components/overview/monitor_list/monitor_list_container");
var _integration_deprecation = require("../components/overview/integration_deprecation");
var _status_panel = require("../components/overview/status_panel");
var _query_bar = require("../components/overview/query_bar/query_bar");
var _routes = require("../routes");
var _filter_group = require("../components/overview/filter_group/filter_group");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EuiFlexItemStyled = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  && {
    min-width: 700px;
    @media only screen and (max-width: 1128px) {
      min-width: 500px;
    }
    @media only screen and (max-width: 630px) {
      min-width: initial;
    }
  }
`;
const OverviewPageComponent = () => {
  (0, _public.useTrackPageview)({
    app: 'uptime',
    path: 'overview'
  });
  (0, _public.useTrackPageview)({
    app: 'uptime',
    path: 'overview',
    delay: 15000
  });
  (0, _use_breadcrumbs.useBreadcrumbs)([{
    text: _routes.MONITORING_OVERVIEW_LABEL
  }]); // No extra breadcrumbs on overview

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_integration_deprecation.IntegrationDeprecation, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    wrap: true,
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_query_bar.QueryBar, null), /*#__PURE__*/_react.default.createElement(EuiFlexItemStyled, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_filter_group.FilterGroup, null))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_status_panel.StatusPanel, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_monitor_list_container.MonitorList, null));
};
exports.OverviewPageComponent = OverviewPageComponent;