"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initTlsAlertType = void 0;
var _react = _interopRequireDefault(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _uptime_alerts = require("../../../../common/constants/uptime_alerts");
var _translations = require("../../../../common/rules/legacy_uptime/translations");
var _ui = require("../../../../common/constants/ui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
let validateFunc;
const {
  defaultActionMessage,
  defaultRecoveryMessage,
  description
} = _translations.TlsTranslations;
const TLSAlert = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./lazy_wrapper/tls_alert'))));
const initTlsAlertType = ({
  core,
  plugins
}) => ({
  id: _uptime_alerts.CLIENT_ALERT_TYPES.TLS,
  iconClass: 'uptimeApp',
  documentationUrl(docLinks) {
    return `${docLinks.links.observability.tlsCertificate}`;
  },
  ruleParamsExpression: params => /*#__PURE__*/_react.default.createElement(TLSAlert, {
    core: core,
    plugins: plugins,
    ruleParams: params.ruleParams,
    setRuleParams: params.setRuleParams
  }),
  description,
  validate: ruleParams => {
    if (!validateFunc) {
      (async function loadValidate() {
        const {
          validateTLSAlertParams
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./lazy_wrapper/validate_tls_alert')));
        validateFunc = validateTLSAlertParams;
      })();
    }
    return validateFunc ? validateFunc(ruleParams) : {};
  },
  defaultActionMessage,
  defaultRecoveryMessage,
  requiresAppContext: false,
  format: ({
    fields
  }) => ({
    reason: fields[_ruleDataUtils.ALERT_REASON] || '',
    link: `/app/uptime${_ui.CERTIFICATES_ROUTE}`
  })
});
exports.initTlsAlertType = initTlsAlertType;