"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateMonitorStatusParams = validateMonitorStatusParams;
var _PathReporter = require("io-ts/lib/PathReporter");
var _Either = require("fp-ts/lib/Either");
var _alerts = require("../../../../../common/runtime_types/alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function validateMonitorStatusParams(ruleParams) {
  var _ruleParams$shouldChe, _ruleParams$shouldChe2;
  const errors = {};
  const decoded = _alerts.AtomicStatusCheckParamsType.decode(ruleParams);
  const oldDecoded = _alerts.StatusCheckParamsType.decode(ruleParams);
  const availabilityDecoded = _alerts.MonitorAvailabilityType.decode(ruleParams);
  if (!(0, _Either.isRight)(decoded) && !(0, _Either.isRight)(oldDecoded) && !(0, _Either.isRight)(availabilityDecoded)) {
    return {
      errors: {
        typeCheckFailure: 'Provided parameters do not conform to the expected type.',
        typeCheckParsingMessage: _PathReporter.PathReporter.report(decoded)
      }
    };
  }
  if (!((_ruleParams$shouldChe = ruleParams.shouldCheckAvailability) !== null && _ruleParams$shouldChe !== void 0 ? _ruleParams$shouldChe : false) && !((_ruleParams$shouldChe2 = ruleParams.shouldCheckStatus) !== null && _ruleParams$shouldChe2 !== void 0 ? _ruleParams$shouldChe2 : false)) {
    return {
      errors: {
        noAlertSelected: 'Alert must check for monitor status or monitor availability.'
      }
    };
  }
  if ((0, _Either.isRight)(decoded) && decoded.right.shouldCheckStatus) {
    const {
      numTimes,
      timerangeCount
    } = decoded.right;
    if (numTimes < 1) {
      errors.invalidNumTimes = 'Number of alert check down times must be an integer greater than 0';
    }
    if (isNaN(timerangeCount)) {
      errors.timeRangeStartValueNaN = 'Specified time range value must be a number';
    }
    if (timerangeCount <= 0) {
      errors.invalidTimeRangeValue = 'Time range value must be greater than 0';
    }
  }
  return {
    errors
  };
}