"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUptimeTelemetry = exports.UptimePage = void 0;
var _react = require("react");
var _use_url_params = require("./use_url_params");
var _utils = require("../state/api/utils");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let UptimePage;
exports.UptimePage = UptimePage;
(function (UptimePage) {
  UptimePage["Overview"] = "GettingStarted";
  UptimePage["MappingError"] = "MappingError";
  UptimePage["Monitor"] = "Monitor";
  UptimePage["MonitorAdd"] = "AddMonitor";
  UptimePage["MonitorEdit"] = "EditMonitor";
  UptimePage["MonitorManagement"] = "MonitorManagement";
  UptimePage["Settings"] = "Settings";
  UptimePage["Certificates"] = "Certificates";
  UptimePage["StepDetail"] = "StepDetail";
  UptimePage["SyntheticCheckStepsPage"] = "SyntheticCheckStepsPage";
  UptimePage["NotFound"] = "__not-found__";
})(UptimePage || (exports.UptimePage = UptimePage = {}));
const useUptimeTelemetry = page => {
  const {
    dateRangeStart,
    dateRangeEnd,
    autorefreshInterval,
    autorefreshIsPaused
  } = (0, _use_url_params.useGetUrlParams)();
  (0, _react.useEffect)(() => {
    if (!_utils.apiService.http) throw new Error('Core http services are not defined');
    const params = {
      page,
      autorefreshInterval: autorefreshInterval / 1000,
      // divide by 1000 to keep it in secs
      dateStart: dateRangeStart,
      dateEnd: dateRangeEnd,
      autoRefreshEnabled: !autorefreshIsPaused
    };
    setTimeout(() => {
      _utils.apiService.post(_constants.API_URLS.LOG_PAGE_VIEW, params);
    }, 100);
  }, [autorefreshInterval, autorefreshIsPaused, dateRangeEnd, dateRangeStart, page]);
};
exports.useUptimeTelemetry = useUptimeTelemetry;