"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSelectedFilters = exports.getFiltersFromMap = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _use_url_params = require("./use_url_params");
var _translations = require("../components/overview/filter_group/translations");
var _constants = require("../../../common/constants");
var _use_filter_update = require("./use_filter_update");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFiltersFromMap = map => {
  var _map$get, _map$get2, _map$get3, _map$get4;
  if (typeof map === 'undefined') {
    return {
      locations: [],
      ports: [],
      schemes: [],
      tags: []
    };
  }
  const {
    LOCATION,
    TAGS,
    TYPE,
    PORT
  } = _constants.FILTER_FIELDS;
  return {
    locations: (_map$get = map.get(LOCATION)) !== null && _map$get !== void 0 ? _map$get : [],
    ports: (_map$get2 = map.get(PORT)) !== null && _map$get2 !== void 0 ? _map$get2 : [],
    schemes: (_map$get3 = map.get(TYPE)) !== null && _map$get3 !== void 0 ? _map$get3 : [],
    tags: (_map$get4 = map.get(TAGS)) !== null && _map$get4 !== void 0 ? _map$get4 : []
  };
};
exports.getFiltersFromMap = getFiltersFromMap;
const useSelectedFilters = () => {
  const {
    filters,
    excludedFilters
  } = (0, _use_url_params.useGetUrlParams)();
  const isMonitorPage = (0, _reactRouterDom.useRouteMatch)(_constants.MONITOR_ROUTE);
  return (0, _react.useMemo)(() => {
    const selectedFilters = (0, _use_filter_update.parseFiltersMap)(filters);
    const excludedFiltersMap = (0, _use_filter_update.parseFiltersMap)(excludedFilters);
    const {
      TAG,
      SCHEME,
      PORT,
      LOCATION
    } = _translations.filterLabels;
    const {
      locations: selectedLocations,
      ports: selectedPorts,
      schemes: selectedSchemes,
      tags: selectedTags
    } = getFiltersFromMap(selectedFilters);
    const {
      locations: excludedLocations,
      ports: excludedPorts,
      schemes: excludedSchemes,
      tags: excludedTags
    } = getFiltersFromMap(excludedFiltersMap);
    const filtersList = [{
      field: 'observer.geo.name',
      label: LOCATION,
      selectedItems: selectedLocations,
      excludedItems: excludedLocations
    },
    // on monitor page we only display location filter in ping list
    ...(!isMonitorPage ? [{
      field: 'url.port',
      label: PORT,
      selectedItems: selectedPorts,
      excludedItems: excludedPorts
    }, {
      field: 'monitor.type',
      label: SCHEME,
      selectedItems: selectedSchemes,
      excludedItems: excludedSchemes
    }, {
      field: 'tags',
      label: TAG,
      selectedItems: selectedTags,
      excludedItems: excludedTags
    }] : [])];
    return {
      excludedLocations,
      selectedTags,
      selectedPorts,
      selectedSchemes,
      selectedLocations,
      filtersList
    };
  }, [excludedFilters, filters, isMonitorPage]);
};
exports.useSelectedFilters = useSelectedFilters;