"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBreadcrumbs = exports.makeBaseBreadcrumb = void 0;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _stringify_url_params = require("../lib/helper/url_params/stringify_url_params");
var _ = require(".");
var _plugin = require("../../../common/constants/plugin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_QUERY = '?';
function handleBreadcrumbClick(breadcrumbs, navigateToHref) {
  return breadcrumbs.map(bc => ({
    ...bc,
    ...(bc.href ? {
      onClick: event => {
        if (navigateToHref && bc.href) {
          event.preventDefault();
          navigateToHref(bc.href);
        }
      }
    } : {})
  }));
}
const makeBaseBreadcrumb = (uptimePath, observabilityPath, params) => {
  if (params) {
    const crumbParams = {
      ...params
    };
    delete crumbParams.statusFilter;
    const query = (0, _stringify_url_params.stringifyUrlParams)(crumbParams, true);
    uptimePath += query === EMPTY_QUERY ? '' : query;
  }
  return [{
    text: _i18n.i18n.translate('xpack.synthetics.breadcrumbs.observabilityText', {
      defaultMessage: 'Observability'
    }),
    href: observabilityPath
  }, {
    text: _i18n.i18n.translate('xpack.synthetics.breadcrumbs.legacyOverviewBreadcrumbText', {
      defaultMessage: 'Uptime'
    }),
    href: uptimePath
  }];
};
exports.makeBaseBreadcrumb = makeBaseBreadcrumb;
const useBreadcrumbs = extraCrumbs => {
  var _kibana$services$chro, _kibana$services$appl, _kibana$services$appl2, _kibana$services$appl3, _kibana$services$appl4, _kibana$services$appl5;
  const params = (0, _.useUrlParams)()[0]();
  const kibana = (0, _public.useKibana)();
  const setBreadcrumbs = (_kibana$services$chro = kibana.services.chrome) === null || _kibana$services$chro === void 0 ? void 0 : _kibana$services$chro.setBreadcrumbs;
  const uptimePath = (_kibana$services$appl = (_kibana$services$appl2 = kibana.services.application) === null || _kibana$services$appl2 === void 0 ? void 0 : _kibana$services$appl2.getUrlForApp(_plugin.PLUGIN.ID)) !== null && _kibana$services$appl !== void 0 ? _kibana$services$appl : '';
  const observabilityPath = (_kibana$services$appl3 = (_kibana$services$appl4 = kibana.services.application) === null || _kibana$services$appl4 === void 0 ? void 0 : _kibana$services$appl4.getUrlForApp('observability-overview')) !== null && _kibana$services$appl3 !== void 0 ? _kibana$services$appl3 : '';
  const navigate = (_kibana$services$appl5 = kibana.services.application) === null || _kibana$services$appl5 === void 0 ? void 0 : _kibana$services$appl5.navigateToUrl;
  (0, _react.useEffect)(() => {
    if (setBreadcrumbs) {
      setBreadcrumbs(handleBreadcrumbClick(makeBaseBreadcrumb(uptimePath, observabilityPath, params).concat(extraCrumbs), navigate));
    }
  }, [uptimePath, observabilityPath, extraCrumbs, navigate, params, setBreadcrumbs]);
};
exports.useBreadcrumbs = useBreadcrumbs;