"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConsoleOutputEventList = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _console_event = require("./console_event");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CONSOLE_STEP_TYPES = ['stderr', 'stdout', 'cmd/status'];
const isConsoleStep = step => CONSOLE_STEP_TYPES.some(type => type === step.synthetics.type);
const ConsoleOutputEventList = ({
  journey
}) => /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.synthetics.synthetics.consoleStepList.title",
  defaultMessage: "No steps ran"
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.synthetics.synthetics.consoleStepList.message",
  defaultMessage: "This journey failed to run, recorded console output is shown below:"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, null, journey.steps.filter(isConsoleStep).map(consoleEvent => /*#__PURE__*/_react.default.createElement(_console_event.ConsoleEvent, {
  event: consoleEvent,
  key: consoleEvent._id + '_console-event-row'
}))));
exports.ConsoleOutputEventList = ConsoleOutputEventList;