"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WHERE_ARE_MY_MONITORS = exports.TroubleshootPopover = exports.SYSTEM_CLOCK_OUT_OF_SYNC = exports.APPLY_ABSOLUTE_DATE_RANGE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _i18nReact = require("@kbn/i18n-react");
var _selectors = require("../../../state/selectors");
var _hooks = require("../../../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TroubleshootPopover = () => {
  var _pingHistogram$histog;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => setIsPopoverOpen(prevState => !prevState);
  const closePopover = () => setIsPopoverOpen(false);
  const {
    pingHistogram
  } = (0, _reactRedux.useSelector)(_selectors.selectPingHistogram);
  const updatedUrlParams = (0, _hooks.useUrlParams)()[1];
  const histogram = (_pingHistogram$histog = pingHistogram === null || pingHistogram === void 0 ? void 0 : pingHistogram.histogram) !== null && _pingHistogram$histog !== void 0 ? _pingHistogram$histog : [];
  const middleBucketTimestamp = histogram === null || histogram === void 0 ? void 0 : histogram[Math.floor(histogram.length / 2)].x;
  const firstBucketTimestamp = histogram === null || histogram === void 0 ? void 0 : histogram[0].x;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "syntheticsTroubleshootPopoverButton",
      onClick: onButtonClick
    }, WHERE_ARE_MY_MONITORS),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "upCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, SYSTEM_CLOCK_OUT_OF_SYNC), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '300px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.monitorList.noMessage.troubleshoot",
    defaultMessage: "Try using an absolute date range. If monitors appears afterwards, there may be an issue with the system clock where Heartbeat or Kibana is installed."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsTroubleshootPopoverButton",
    fullWidth: true,
    iconType: "calendar",
    size: "s",
    onClick: () => {
      if (middleBucketTimestamp && firstBucketTimestamp) {
        updatedUrlParams({
          dateRangeStart: new Date(firstBucketTimestamp).toISOString(),
          dateRangeEnd: new Date(middleBucketTimestamp).toISOString()
        });
      }
    }
  }, APPLY_ABSOLUTE_DATE_RANGE)));
};
exports.TroubleshootPopover = TroubleshootPopover;
const APPLY_ABSOLUTE_DATE_RANGE = _i18n.i18n.translate('xpack.synthetics.monitorList.troubleshoot.tryDateRange', {
  defaultMessage: 'Apply absolute date range'
});
exports.APPLY_ABSOLUTE_DATE_RANGE = APPLY_ABSOLUTE_DATE_RANGE;
const WHERE_ARE_MY_MONITORS = _i18n.i18n.translate('xpack.synthetics.monitorList.troubleshoot.whereAreMyMonitors', {
  defaultMessage: 'Where are my monitors?'
});
exports.WHERE_ARE_MY_MONITORS = WHERE_ARE_MY_MONITORS;
const SYSTEM_CLOCK_OUT_OF_SYNC = _i18n.i18n.translate('xpack.synthetics.monitorList.troubleshoot.systemClockOutOfSync', {
  defaultMessage: 'System clock may be out of sync'
});
exports.SYSTEM_CLOCK_OUT_OF_SYNC = SYSTEM_CLOCK_OUT_OF_SYNC;