"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorListPageSizeSelectComponent = exports.MonitorListPageSizeSelect = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PopoverButton = ({
  setIsOpen,
  size
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  color: "text",
  "data-test-subj": "xpack.synthetics.monitorList.pageSizeSelect.popoverOpen",
  iconType: "arrowDown",
  iconSide: "right",
  onClick: () => setIsOpen(true)
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.synthetics.monitorList.pageSizePopoverButtonText",
  defaultMessage: "Rows per page: {size}",
  values: {
    size
  }
}));
const items = [{
  'data-test-subj': 'xpack.synthetics.monitorList.pageSizeSelect.sizeSelectItem10',
  key: '10 rows',
  numRows: 10
}, {
  'data-test-subj': 'xpack.synthetics.monitorList.pageSizeSelect.sizeSelectItem25',
  key: '25 rows',
  numRows: 25
}, {
  'data-test-subj': 'xpack.synthetics.monitorList.pageSizeSelect.sizeSelectItem50',
  key: '50 rows',
  numRows: 50
}, {
  'data-test-subj': 'xpack.synthetics.monitorList.pageSizeSelect.sizeSelectItem100',
  key: '100 rows',
  numRows: 100
}];
const LOCAL_STORAGE_KEY = 'xpack.uptime.monitorList.pageSize';
/**
 * This component wraps the underlying UI functionality to make the component more testable.
 * The features leveraged in this function are tested elsewhere, and are not novel to this component.
 */
const MonitorListPageSizeSelect = ({
  size,
  setSize
}) => {
  const [, setUrlParams] = (0, _hooks.useUrlParams)();
  (0, _react.useEffect)(() => {
    localStorage.setItem(LOCAL_STORAGE_KEY, size.toString());
  }, [size]);
  return /*#__PURE__*/_react.default.createElement(MonitorListPageSizeSelectComponent, {
    size: size,
    setSize: setSize,
    setUrlParams: setUrlParams
  });
};
exports.MonitorListPageSizeSelect = MonitorListPageSizeSelect;
/**
 * This function contains the UI functionality for the page select feature. It's agnostic to any
 * external services/features, and focuses only on providing the UI and handling user interaction.
 */
const MonitorListPageSizeSelectComponent = ({
  size,
  setSize,
  setUrlParams
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(PopoverButton, {
      setIsOpen: value => setIsOpen(value),
      size: size
    }),
    isOpen: isOpen,
    closePopover: () => setIsOpen(false),
    anchorPosition: "upLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items.map(({
      'data-test-subj': dataTestSubj,
      key,
      numRows
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": dataTestSubj,
      key: key,
      icon: size === numRows ? 'check' : 'empty',
      onClick: () => {
        setSize(numRows);
        // reset pagination because the page size has changed
        setUrlParams({
          pagination: undefined
        });
        setIsOpen(false);
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.monitorList.pageSizeSelect.numRowsItemMessage",
      defaultMessage: "{numRows} rows",
      values: {
        numRows
      }
    })))
  }));
};
exports.MonitorListPageSizeSelectComponent = MonitorListPageSizeSelectComponent;