"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorListDrawer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _selectors = require("../../../../state/selectors");
var _monitor = require("../../../../state/actions/monitor");
var _monitor_list_drawer = require("./monitor_list_drawer");
var _hooks = require("../../../../hooks");
var _alerts = require("../../../../state/alerts/alerts");
var _contexts = require("../../../../contexts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorListDrawer = ({
  summary
}) => {
  var _alerts$data;
  const {
    lastRefresh
  } = (0, _react.useContext)(_contexts.UptimeRefreshContext);
  const monitorId = summary === null || summary === void 0 ? void 0 : summary.monitor_id;
  const {
    dateRangeStart: dateStart,
    dateRangeEnd: dateEnd
  } = (0, _hooks.useGetUrlParams)();
  const monitorDetails = (0, _reactRedux.useSelector)(state => (0, _selectors.monitorDetailsSelector)(state, summary));
  const isLoading = (0, _reactRedux.useSelector)(_selectors.monitorDetailsLoadingSelector);
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    data: alerts,
    loading: alertsLoading
  } = (0, _reactRedux.useSelector)(_alerts.alertsSelector);
  const hasAlert = ((_alerts$data = alerts === null || alerts === void 0 ? void 0 : alerts.data) !== null && _alerts$data !== void 0 ? _alerts$data : []).find(alert => alert.params.search.includes(monitorId));
  (0, _react.useEffect)(() => {
    dispatch(_monitor.getMonitorDetailsAction.get({
      dateStart,
      dateEnd,
      monitorId
    }));
  }, [dateStart, dateEnd, monitorId, dispatch, hasAlert, lastRefresh]);
  return /*#__PURE__*/_react.default.createElement(_monitor_list_drawer.MonitorListDrawerComponent, {
    monitorDetails: monitorDetails,
    summary: summary,
    loading: isLoading || alertsLoading
  });
};
exports.MonitorListDrawer = MonitorListDrawer;