"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TAG_KEY_FOR_AND_CONDITION = exports.FilterGroup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _lodash = require("lodash");
var _public = require("@kbn/exploratory-view-plugin/public");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _use_filter_update = require("../../../hooks/use_filter_update");
var _use_selected_filters = require("../../../hooks/use_selected_filters");
var _selected_filters = require("./selected_filters");
var _uptime_data_view_context = require("../../../contexts/uptime_data_view_context");
var _hooks = require("../../../hooks");
var _client_defaults = require("../../../../../common/constants/client_defaults");
var _uptime_refresh_context = require("../../../contexts/uptime_refresh_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Container = (0, _styledComponents.default)(_eui.EuiFilterGroup)`
  margin-bottom: 10px;
`;
const TAG_KEY_FOR_AND_CONDITION = 'useANDForTagsFilter';
exports.TAG_KEY_FOR_AND_CONDITION = TAG_KEY_FOR_AND_CONDITION;
const FilterGroup = () => {
  const [updatedFieldValues, setUpdatedFieldValues] = (0, _react.useState)({
    fieldName: '',
    values: [],
    notValues: []
  });
  (0, _use_filter_update.useFilterUpdate)(updatedFieldValues.fieldName, updatedFieldValues.values, updatedFieldValues.notValues);
  const {
    refreshApp
  } = (0, _uptime_refresh_context.useUptimeRefreshContext)();
  const {
    dateRangeStart,
    dateRangeEnd
  } = (0, _hooks.useGetUrlParams)();
  const {
    inspectorAdapters
  } = (0, _public.useInspectorContext)();
  const {
    filtersList
  } = (0, _use_selected_filters.useSelectedFilters)();
  const dataView = (0, _uptime_data_view_context.useUptimeDataView)();
  const [useLogicalAND, setLogicalANDForTag] = (0, _useLocalStorage.default)(TAG_KEY_FOR_AND_CONDITION, false);
  const onFilterFieldChange = (0, _react.useCallback)((fieldName, values, notValues) => {
    setUpdatedFieldValues({
      fieldName,
      values,
      notValues
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Container, null, dataView && filtersList.map(({
    field,
    label,
    selectedItems,
    excludedItems
  }) => /*#__PURE__*/_react.default.createElement(_public.FieldValueSuggestions, {
    key: field,
    compressed: false,
    dataViewTitle: dataView.title,
    sourceField: field,
    label: label,
    selectedValue: selectedItems,
    excludedValue: excludedItems,
    onChange: (values, notValues, isLogicalAND) => {
      onFilterFieldChange(field, values !== null && values !== void 0 ? values : [], notValues !== null && notValues !== void 0 ? notValues : []);
      if (isLogicalAND !== undefined) {
        setLogicalANDForTag(isLogicalAND);
        setTimeout(() => refreshApp(), 0);
      }
    },
    asCombobox: false,
    asFilterButton: true,
    forceOpen: false,
    filters: [{
      exists: {
        field: 'summary'
      }
    }, _client_defaults.EXCLUDE_RUN_ONCE_FILTER],
    cardinalityField: "monitor.id",
    time: {
      from: dateRangeStart,
      to: dateRangeEnd
    },
    inspector: {
      adapter: inspectorAdapters.requests,
      title: 'get' + (0, _lodash.capitalize)(label) + 'FilterValues'
    },
    showLogicalConditionSwitch: field === 'tags',
    useLogicalAND: field === 'tags' ? useLogicalAND : undefined
  }))), /*#__PURE__*/_react.default.createElement(_selected_filters.SelectedFilters, {
    onChange: onFilterFieldChange
  }));
};
exports.FilterGroup = FilterGroup;