"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyAlertComponent = AnomalyAlertComponent;
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/ml-plugin/public");
var _translations = require("./translations");
var _alert_expression_popover = require("../alert_expression_popover");
var _select_severity = require("./select_severity");
var _selectors = require("../../../../state/selectors");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AnomalyAlertComponent({
  setRuleParams,
  ruleParams
}) {
  const [severity, setSeverity] = (0, _react.useState)(_select_severity.DEFAULT_SEVERITY);
  const monitorIdStore = (0, _reactRedux.useSelector)(_selectors.monitorIdSelector);
  const monitorId = monitorIdStore || (ruleParams === null || ruleParams === void 0 ? void 0 : ruleParams.monitorId);
  (0, _react.useEffect)(() => {
    setRuleParams('monitorId', monitorId);
  }, [monitorId, setRuleParams]);
  (0, _react.useEffect)(() => {
    setRuleParams('severity', severity.val);
  }, [severity, setRuleParams]);
  (0, _react.useEffect)(() => {
    if (ruleParams.severity !== undefined) {
      setSeverity(_select_severity.SEVERITY_OPTIONS.find(({
        val
      }) => val === ruleParams.severity));
    }

    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: 'column',
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
    description: _translations.AnomalyTranslations.whenMonitor,
    value: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      className: "eui-displayInlineBlock"
    }, /*#__PURE__*/_react.default.createElement("h5", null, monitorId))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_alert_expression_popover.AlertExpressionPopover, {
    "aria-label": _translations.AnomalyTranslations.scoreAriaLabel,
    content: /*#__PURE__*/_react.default.createElement(_select_severity.SelectSeverity, {
      "data-test-subj": "uptimeAnomalySeverityValue",
      value: severity,
      onChange: setSeverity
    }),
    "data-test-subj": 'uptimeAnomalySeverity',
    description: _translations.AnomalyTranslations.hasAnomalyWithSeverity,
    id: "severity",
    value: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      style: {
        textTransform: 'capitalize'
      },
      color: (0, _public.getSeverityColor)(severity.val)
    }, (0, _public.getSeverity)(severity.val).label),
    isEnabled: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
}