"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSnapShotCount = void 0;
var _public = require("@kbn/observability-plugin/public");
var _hooks = require("../../../../hooks");
var _api = require("../../../../state/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSnapShotCount = ({
  query,
  filters
}) => {
  const parsedFilters = filters === undefined || typeof filters === 'string' ? '' : JSON.stringify(Array.from(Object.entries(filters)));
  const [esKuery, error] = (0, _hooks.useGenerateUpdatedKueryString)(query, parsedFilters, undefined, true);
  const {
    data,
    loading
  } = (0, _public.useFetcher)(() => (0, _api.fetchSnapshotCount)({
    dateRangeStart: 'now-24h',
    dateRangeEnd: 'now',
    filters: error ? undefined : esKuery
  }), [esKuery, query]);
  return {
    count: data || {
      total: 0,
      up: 0,
      down: 0
    },
    loading
  };
};
exports.useSnapShotCount = useSnapShotCount;