"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertTlsComponent = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertTlsComponent = ({
  ageThreshold,
  expirationThreshold,
  setAgeThreshold,
  setExpirationThreshold
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "none"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
  "aria-label": _translations.TlsTranslations.criteriaAriaLabel,
  color: "success",
  description: _translations.TlsTranslations.criteriaDescription,
  value: _translations.TlsTranslations.criteriaValue
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  "data-test-subj": "tlsExpirationThreshold"
}, /*#__PURE__*/_react.default.createElement(_public.ValueExpression, {
  value: expirationThreshold,
  onChangeSelectedValue: val => {
    setExpirationThreshold(val);
  },
  description: _translations.TlsTranslations.expirationDescription,
  errors: []
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  "data-test-subj": "tlsAgeExpirationThreshold"
}, /*#__PURE__*/_react.default.createElement(_public.ValueExpression, {
  value: ageThreshold,
  onChangeSelectedValue: val => {
    setAgeThreshold(val);
  },
  description: _translations.TlsTranslations.ageDescription,
  errors: []
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l"
}));
exports.AlertTlsComponent = AlertTlsComponent;