"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkRequestsTotal = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _styles = require("./styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NetworkRequestsTotal = ({
  totalNetworkRequests,
  fetchedNetworkRequests,
  highlightedNetworkRequests,
  showHighlightedNetworkRequests
}) => {
  return /*#__PURE__*/_react.default.createElement(_styles.NetworkRequestsTotalStyle, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.synthetics.waterfall.requestsTotalMessage",
    defaultMessage: "{numNetworkRequests} network requests",
    values: {
      numNetworkRequests: totalNetworkRequests > fetchedNetworkRequests ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.synthetics.waterfall.requestsTotalMessage.first",
        defaultMessage: "First {count}",
        values: {
          count: `${fetchedNetworkRequests}/${totalNetworkRequests}`
        }
      }) : totalNetworkRequests
    }
  }), ' ', showHighlightedNetworkRequests && highlightedNetworkRequests >= 0 && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.synthetics.waterfall.requestsHighlightedMessage",
    defaultMessage: "({numHighlightedRequests} match the filter)",
    values: {
      numHighlightedRequests: highlightedNetworkRequests
    }
  })), totalNetworkRequests > fetchedNetworkRequests && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: 'iInCircle',
    content: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfall.requestsTotalMessage.info', {
      defaultMessage: 'Waterfall view only shows up to 1000 requests'
    })
  }));
};
exports.NetworkRequestsTotal = NetworkRequestsTotal;