"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStepWaterfallMetrics = exports.NAVIGATION_START = exports.BROWSER_TRACE_TYPE = exports.BROWSER_TRACE_START = exports.BROWSER_TRACE_NAME = void 0;
var _reactRedux = require("react-redux");
var _public = require("@kbn/observability-plugin/public");
var _selectors = require("../../../../state/selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BROWSER_TRACE_TYPE = 'browser.relative_trace.type';
exports.BROWSER_TRACE_TYPE = BROWSER_TRACE_TYPE;
const BROWSER_TRACE_NAME = 'browser.relative_trace.name';
exports.BROWSER_TRACE_NAME = BROWSER_TRACE_NAME;
const BROWSER_TRACE_START = 'browser.relative_trace.start.us';
exports.BROWSER_TRACE_START = BROWSER_TRACE_START;
const NAVIGATION_START = 'navigationStart';
exports.NAVIGATION_START = NAVIGATION_START;
const useStepWaterfallMetrics = ({
  checkGroup,
  hasNavigationRequest,
  stepIndex
}) => {
  const {
    settings
  } = (0, _reactRedux.useSelector)(_selectors.selectDynamicSettings);
  const heartbeatIndices = (settings === null || settings === void 0 ? void 0 : settings.heartbeatIndices) || '';
  const {
    data,
    loading
  } = (0, _public.useEsSearch)(hasNavigationRequest ? (0, _public.createEsParams)({
    index: heartbeatIndices,
    body: {
      query: {
        bool: {
          filter: [{
            term: {
              'synthetics.step.index': stepIndex
            }
          }, {
            term: {
              'monitor.check_group': checkGroup
            }
          }, {
            term: {
              'synthetics.type': 'step/metrics'
            }
          }]
        }
      },
      fields: ['browser.*'],
      size: 1000,
      _source: false
    }
  }) : {}, [heartbeatIndices, checkGroup, hasNavigationRequest], {
    name: 'getWaterfallStepMetrics'
  });
  if (!hasNavigationRequest) {
    return {
      metrics: [],
      loading: false
    };
  }
  const metrics = [];
  if (data && hasNavigationRequest) {
    const metricDocs = data.hits.hits;
    let navigationStart = 0;
    let navigationStartExist = false;
    metricDocs.forEach(({
      fields
    }) => {
      var _fields$BROWSER_TRACE;
      if (((_fields$BROWSER_TRACE = fields[BROWSER_TRACE_TYPE]) === null || _fields$BROWSER_TRACE === void 0 ? void 0 : _fields$BROWSER_TRACE[0]) === 'mark') {
        const {
          [BROWSER_TRACE_NAME]: metricType,
          [BROWSER_TRACE_START]: metricValue
        } = fields;
        if ((metricType === null || metricType === void 0 ? void 0 : metricType[0]) === NAVIGATION_START) {
          navigationStart = metricValue === null || metricValue === void 0 ? void 0 : metricValue[0];
          navigationStartExist = true;
        }
      }
    });
    if (navigationStartExist) {
      metricDocs.forEach(({
        fields
      }) => {
        var _fields$BROWSER_TRACE2;
        if (((_fields$BROWSER_TRACE2 = fields[BROWSER_TRACE_TYPE]) === null || _fields$BROWSER_TRACE2 === void 0 ? void 0 : _fields$BROWSER_TRACE2[0]) === 'mark') {
          const {
            [BROWSER_TRACE_NAME]: metricType,
            [BROWSER_TRACE_START]: metricValue
          } = fields;
          if ((metricType === null || metricType === void 0 ? void 0 : metricType[0]) !== NAVIGATION_START) {
            metrics.push({
              id: metricType === null || metricType === void 0 ? void 0 : metricType[0],
              offset: ((metricValue === null || metricValue === void 0 ? void 0 : metricValue[0]) - navigationStart) / 1000
            });
          }
        }
      });
    }
  }
  return {
    metrics,
    loading
  };
};
exports.useStepWaterfallMetrics = useStepWaterfallMetrics;