"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorStatusDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _hooks = require("../../../hooks");
var _selectors = require("../../../state/selectors");
var _monitor = require("../../../state/actions/monitor");
var _ = require(".");
var _contexts = require("../../../contexts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorStatusDetails = ({
  monitorId
}) => {
  const {
    lastRefresh
  } = (0, _react.useContext)(_contexts.UptimeRefreshContext);
  const {
    dateRangeStart: dateStart,
    dateRangeEnd: dateEnd
  } = (0, _hooks.useGetUrlParams)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const monitorLocations = (0, _reactRedux.useSelector)(state => (0, _selectors.monitorLocationsSelector)(state, monitorId));
  (0, _react.useEffect)(() => {
    dispatch((0, _monitor.getMonitorLocationsAction)({
      dateStart,
      dateEnd,
      monitorId
    }));
  }, [monitorId, dateStart, dateEnd, lastRefresh, dispatch]);
  return /*#__PURE__*/_react.default.createElement(_.MonitorStatusDetailsComponent, {
    monitorLocations: monitorLocations
  });
};
exports.MonitorStatusDetails = MonitorStatusDetails;