"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStatusBar = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _contexts = require("../../../../contexts");
var _hooks = require("../../../../hooks");
var _selectors = require("../../../../state/selectors");
var _actions = require("../../../../state/actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStatusBar = () => {
  const {
    lastRefresh
  } = (0, _react.useContext)(_contexts.UptimeRefreshContext);
  const {
    dateRangeStart: dateStart,
    dateRangeEnd: dateEnd
  } = (0, _hooks.useGetUrlParams)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const monitorId = (0, _hooks.useMonitorId)();
  const monitorStatus = (0, _reactRedux.useSelector)(_selectors.monitorStatusSelector);
  const monitorLocations = (0, _reactRedux.useSelector)(state => (0, _selectors.monitorLocationsSelector)(state, monitorId));
  (0, _react.useEffect)(() => {
    dispatch((0, _actions.getMonitorStatusAction)({
      dateStart,
      dateEnd,
      monitorId
    }));
  }, [monitorId, dateStart, dateEnd, lastRefresh, dispatch]);
  return {
    monitorStatus,
    monitorLocations,
    monitorId
  };
};
exports.useStatusBar = useStatusBar;