"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePingsList = void 0;
var _reactRedux = require("react-redux");
var _react = require("react");
var _public = require("@kbn/observability-plugin/public");
var _selectors = require("../../../state/selectors");
var _actions = require("../../../state/actions");
var _hooks = require("../../../hooks");
var _contexts = require("../../../contexts");
var _journey = require("../../../state/api/journey");
var _use_selected_filters = require("../../../hooks/use_selected_filters");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePingsList = ({
  pageSize,
  pageIndex
}) => {
  const {
    error,
    loading,
    pingList: {
      pings,
      total
    }
  } = (0, _reactRedux.useSelector)(_selectors.selectPingList);
  const {
    lastRefresh
  } = (0, _react.useContext)(_contexts.UptimeRefreshContext);
  const {
    dateRangeStart: from,
    dateRangeEnd: to
  } = (0, _react.useContext)(_contexts.UptimeSettingsContext);
  const {
    statusFilter
  } = (0, _hooks.useGetUrlParams)();
  const selectedFilters = (0, _use_selected_filters.useSelectedFilters)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const monitorId = (0, _hooks.useMonitorId)();
  const getPings = (0, _react.useCallback)(params => dispatch((0, _actions.getPings)(params)), [dispatch]);
  const locations = JSON.stringify(selectedFilters.selectedLocations);
  const excludedLocations = JSON.stringify(selectedFilters.excludedLocations);
  (0, _react.useEffect)(() => {
    getPings({
      monitorId,
      dateRange: {
        from,
        to
      },
      excludedLocations,
      locations,
      index: pageIndex,
      size: pageSize,
      status: statusFilter !== 'all' ? statusFilter : ''
    });
  }, [from, to, getPings, monitorId, lastRefresh, pageIndex, pageSize, statusFilter, locations, excludedLocations]);
  const {
    data
  } = (0, _public.useFetcher)(() => {
    if ((pings === null || pings === void 0 ? void 0 : pings.length) > 0 && pings.find(ping => ping.monitor.type === _constants.MONITOR_TYPES.BROWSER)) return (0, _journey.fetchJourneysFailedSteps)({
      checkGroups: pings.map(ping => ping.monitor.check_group)
    });
  }, [pings]);
  return {
    error,
    loading,
    pings,
    total,
    failedSteps: data
  };
};
exports.usePingsList = usePingsList;