"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInProgressImage = void 0;
var _reactRouterDom = require("react-router-dom");
var _react = require("react");
var _public = require("@kbn/observability-plugin/public");
var _journey = require("../../../../../state/api/journey");
var _constants = require("../../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NUMBER_OF_RETRIES = 20;
const useInProgressImage = ({
  stepStatus,
  hasImage,
  hasIntersected,
  imgPath
}) => {
  const isAddRoute = (0, _reactRouterDom.useRouteMatch)(_constants.MONITOR_ADD_ROUTE);
  const isEditRoute = (0, _reactRouterDom.useRouteMatch)(_constants.MONITOR_EDIT_ROUTE);
  const [retryLoading, setRetryLoading] = (0, _react.useState)(0);
  const skippedStep = stepStatus === 'skipped';
  const {
    data,
    loading
  } = (0, _public.useFetcher)(() => {
    if (skippedStep) {
      return new Promise(resolve => resolve(null));
    }
    if (hasIntersected && !hasImage) return (0, _journey.getJourneyScreenshot)(imgPath);
  }, [hasIntersected, imgPath, skippedStep, retryLoading]);
  (0, _react.useEffect)(() => {
    if (!loading && !hasImage && (isAddRoute !== null && isAddRoute !== void 0 && isAddRoute.isExact || isEditRoute !== null && isEditRoute !== void 0 && isEditRoute.isExact) && !skippedStep) {
      setTimeout(() => {
        setRetryLoading(prevState => {
          if (prevState < NUMBER_OF_RETRIES) {
            return prevState + 1;
          }
          return prevState;
        });
      }, 5 * 1000);
    }
  }, [hasImage, loading, isAddRoute === null || isAddRoute === void 0 ? void 0 : isAddRoute.isExact, isEditRoute === null || isEditRoute === void 0 ? void 0 : isEditRoute.isExact, skippedStep]);
  return {
    data,
    loading
  };
};
exports.useInProgressImage = useInProgressImage;